# Recitation 6: Static semantics practice

- authors:
  - Jonathan Aldrich <https://www.cs.cmu.edu/~aldrich/>
  - Sam Estep <https://samestep.com/>

This recitation is fairly similar to recitation 3: we'll extend the lambda
calculus with syntax for `let`, and repair a couple broken proofs. Unlike in
recitation 3 (in which the proof was very different from HW3), the theorems
we're extending here are the same as the theorems you'll be extending in HW6.

If we have some time at the end then we'll do some more modeling, perhaps by
adding first-class lists to the language.

## Structure

The structure of this recitation is similar to that of the recitations 2 and 3:

    recitation06
    ├── .project
    ├── .settings
    │   ├── org.eclipse.core.resources.prefs
    │   └── org.sasylf.prefs
    ├── README.md
    └── slf
        └── edu
            └── cmu
                └── cs
                    └── plp
                        └── recitation6.slf

Their purposes are as follows:

- `README.md` is this file.
- `.project` and `.settings` are used by Eclipse.
- `slf/edu/cmu/cs/plp/recitation6.slf` is the file we'll be exploring in this
  recitation.

## Exercise

SASyLF should give no errors or warnings about the version of `recitation6.slf`
you were given. Our first goal is to add one more syntactic case for `let`
expressions. You already saw the syntax in recitation 3, but here we're dealing
with the typed lambda calculus, rather than untyped. Does anything change?

Next, we add the small-step semantics for `let`. We did these in recitation 3!
Go ahead and write those in here.

Next, we add the necessary typing rule(s) for `let`.

Finally, we repair the proofs of the `progress` and `preservation` theorems.

## Exploration

What are some other constructs we could model to extend the simply typed lambda
calculus?

## Participation

The instructor will take attendance via Zoom.

