# HW8: Translation correctness

- authors:
  - Sam Estep <https://samestep.com/>
  - Jonathan Aldrich <https://www.cs.cmu.edu/~aldrich/>

Due Friday, November 8, 11:59pm

In this eighth homework assignment, you'll do the following:

- practice simulating code optimizations on paper
- extend the untyped lambda calculus with `let` (as you did in recitation 6)
- extend big-step semantics to account for `let`
- extend constant-folding judgment to account for `let`
- extend constant-folding to do some constant-propagation as well
- construct derivations for a few examples
- repair constant-folding proofs of correctness to handle these extensions

## Assignment structure

The structure of the files in this assignment mirrors that of HW3 and HW6.

## Exercises

### Practice two optimizations discussed in class

Do the practice problems below, and put the answers in a text or PDF file named answers.{txt/pdf}.

#### Value Numbering

Optimize the following code using local value numbering, as shown in class and in textbook section 17.3.2 (note: chapter 17 is in the online supplement).  Show the final code and the final dictionary / table used in value numbering.

    v1 := 0
    v2 := a
    v3 := c
    v4 := v2 + v3
    v5 := 2
    v6 := 1
    v7 := v5 + v6
    v8 := v4 + v7
    b := v8
    v9 := a
    v10 := c
    v11 := v9 + v10
    v12 := i
    v13 := 4
    v14 := v12 * v13
    v15 := v11 + v14
    v16 := v1 * v15

#### Live Variable Analysis

Perform live variable analysis on the following code, and then perform dead code elimination based on the results.  Show how the analysis works by providing a table with three columns: block name ("start", "loop", or "end"), live vars after, and live vars before.  Fill in rows of the table to show the sequence of basic blocks analyzed and the set of live variables after and before that block.  If a block is analyzed N times, then there will be N entries in the table for that block, with the last entry showing the final live variable analysis results for that block.  Remember that live variable analysis is a backwards analysis.

    start:
    x := 10
    y := 10
    z := 10
    v := 10
    w := 10
    t := 10

    loop:
    x := z - 2
    x := y - 1
    y := w * 2
    w := v + 1
    t := t / 2
    if x < 100 goto loop

    end:
    return x

### Add syntax for `let`

Your starter `hw8.slf` file already contains the syntax for `let`, but commented
out. Go ahead and uncomment it.

### Model the big-step semantics for `let`

Add any necessary rules to the `eval` judgment to model the semantics of `let`.

### Allow constant-folding in `let` expressions

Add any necessary rules to the `fold` judgment to allow constant-folding within
`let` expressions. (You only need to handle constant-folding here, not
constant-propagation.)

### Allow constant-propagation for calls

Add any necessary rules to the fold judgment to allow constant-propagation for
calls to functions. (You do not need to handle constant-propagation for `let`
expressions.)

### Fill in the proofs for all the `fold` examples

These include the following:

- `fold-example-1`
- `fold-example-2`
- `fold-example-3`

Note that in the starter code you are given, `fold-example-2` is commented out
because it uses the `let` syntax. Be sure to uncomment it and prove it along
with the other two examples.

### Repair all other proofs

You will need to make modifications to the proofs of the following
lemmas/theorems:

- `rewrite-reflexive`
- `rewrite-composes`
- `rewrite-transitive`
- `fold-correct`

## Submit

Create a hw8.zip file with hw8.slf and answers.{txt/slf}.
On Gradescope, simply submit your hw8.zip file on the HW8 assignment page.

# Rubric

| total                                   | 100% |
|-----------------------------------------|-----:|
| Value Numbering results and work        |  10% |
| Live variable analysis results and work |  10% |
| correct big-step semantics for `let`    |   5% |
| correct constant-folding rule for `let` |  10% |
| correct constant-propagation rule       |  10% |
| correct derivations for examples        |  10% |
| correct proofs                          |  40% |
| code style                              |   5% |
