/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.util;

import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.util.ErrorReport;
import edu.cmu.cs.sasylf.util.SASyLFError;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ErrorHandler {
    private static List<ErrorReport> reports = new ArrayList<ErrorReport>();
    private static int errorCount = 0;
    private static int warningCount = 0;

    public static void report(Errors errorType, String msg, Location loc, String debugInfo, boolean isError, boolean print) {
        if (msg == null) {
            msg = "";
        }
        ErrorReport rep = new ErrorReport(errorType, msg, loc, debugInfo, isError);
        reports.add(rep);
        if (print) {
            System.err.println(rep.getMessage());
        }
        if (debugInfo != null && Util.EXTRA_ERROR_INFO) {
            System.err.println(debugInfo);
        }
        if (isError) {
            ++errorCount;
            throw new SASyLFError(rep);
        }
        ++warningCount;
    }

    public static void warning(Errors errorType, Node obj) {
        ErrorHandler.report(errorType, null, obj.getLocation(), null, false, true);
    }

    public static void warning(String msg, Node obj) {
        ErrorHandler.report(null, msg, obj.getLocation(), null, false, true);
    }

    public static void report(Errors errorType, Node obj) {
        ErrorHandler.report(errorType, null, obj.getLocation(), null, true, true);
    }

    public static void report(Errors errorType, Node obj, String debugInfo) {
        ErrorHandler.report(errorType, null, obj.getLocation(), debugInfo, true, true);
    }

    public static void report(String msg, Node obj) {
        ErrorHandler.report(null, msg, obj.getLocation(), null, true, true);
    }

    public static void report(String msg, Location loc) {
        ErrorHandler.report(null, msg, loc, null, true, true);
    }

    public static void report(Errors errorType, String msg, Node obj) {
        ErrorHandler.report(errorType, msg, obj.getLocation(), null, true, true);
    }

    public static void report(String msg, Node obj, String debugInfo) {
        ErrorHandler.report(null, msg, obj.getLocation(), debugInfo, true, true);
    }

    public static void report(Errors errorType, String msg, Node obj, String debugInfo) {
        ErrorHandler.report(errorType, msg, obj.getLocation(), debugInfo, true, true);
    }

    public static List<ErrorReport> getReports() {
        return reports;
    }

    public static void clearAll() {
        reports = new ArrayList<ErrorReport>();
        errorCount = 0;
        warningCount = 0;
        FreeVar.reinit();
    }

    public static int getErrorCount() {
        return errorCount;
    }
}

