/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.BoundVar;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public abstract class Term {
    static int debugCount = 0;

    public final Substitution freshSubstitution(Substitution s) {
        Set<FreeVar> vars = this.getFreeVariables();
        Util.debug("free vars for freshening: " + vars);
        for (FreeVar v : vars) {
            if (s.getMap().keySet().contains(v)) continue;
            FreeVar vfresh = v.freshify();
            Util.debug("freshened " + v + " with " + vfresh);
            s.add(v, vfresh);
        }
        return s;
    }

    public final Substitution instanceOf(Term t) {
        Set<FreeVar> freeVars = this.getFreeVariables();
        Substitution unifyingSub = this.unify(t);
        if (unifyingSub.avoid(freeVars)) {
            return unifyingSub;
        }
        throw new UnificationFailed("terms unify but the instance relationship does not hold");
    }

    int getOrder() {
        return 2;
    }

    final int oneIfNonPatFreeVarApp() {
        return this.isNonPatFreeVarApp() ? 1 : 0;
    }

    final int oneIfNonPatFreeVarApp(Term other) {
        return this.isNonPatFreeVarApp(other) ? 1 : 0;
    }

    boolean isNonPatFreeVarApp() {
        return false;
    }

    boolean isNonPatFreeVarApp(Term other) {
        return false;
    }

    static Pair<Term, Term> makePair(Term t1, Term t2) {
        Util.debug("    pair " + t1 + " order " + t1.getOrder());
        Util.debug("    pair " + t2 + " order " + t2.getOrder());
        if (t1.getOrder() < t2.getOrder()) {
            return new Pair<Term, Term>(t1, t2);
        }
        return new Pair<Term, Term>(t2, t1);
    }

    public final Substitution unifyAllowingBVs(Term t) {
        Substitution current = new Substitution();
        PriorityQueue<Pair<Term, Term>> worklist = new PriorityQueue<Pair<Term, Term>>(11, new PairComparator());
        worklist.add(Term.makePair(this, t));
        debugCount = 0;
        Term.unifyHelper(current, worklist);
        return current;
    }

    public final Substitution unify(Term t) {
        Substitution current = this.unifyAllowingBVs(t);
        Set<FreeVar> freeVars = this.getFreeVariables();
        freeVars.addAll(t.getFreeVariables());
        for (FreeVar v : freeVars) {
            Term substituted = current.getSubstituted(v);
            if (substituted == null || !substituted.hasBoundVarAbove(0)) continue;
            Util.debug("Could not eliminate bound variables from substitution " + substituted + " for var " + v);
            throw new UnificationFailed("illegal variable binding in result: " + substituted + " for " + v + "\n" + current);
        }
        return current;
    }

    static final void unifyHelper(Substitution current, Queue<Pair<Term, Term>> worklist) {
        Pair<Term, Term> p;
        if (debugCount++ == 30) {
            Util.debug2("in loop");
        }
        if ((p = worklist.poll()) != null) {
            if (!Term.typesCompatible(((Term)p.first).getType(new ArrayList<Pair<String, Term>>()), ((Term)p.second).getType(new ArrayList<Pair<String, Term>>()))) {
                Util.debug("tried to unify " + ((Term)p.first).substitute(current) + " with " + ((Term)p.second).substitute(current) + " but types didn't match:");
                Util.debug("\ttypes were " + ((Term)p.first).getType(new ArrayList<Pair<String, Term>>()) + " and " + ((Term)p.second).getType(new ArrayList<Pair<String, Term>>()));
                throw new UnificationFailed("unifying things whose types don't match");
            }
            Util.debug("subtask: unify " + ((Term)p.first).substitute(current) + " with " + ((Term)p.second).substitute(current));
            Util.debug("    raw " + p.first + " with " + p.second);
            Util.debug("    substitution: " + current);
            Util.debug("    worklist: " + worklist);
            ((Term)p.first).unifyCase((Term)p.second, current, worklist);
        }
    }

    public boolean typeEquals(Term otherType) {
        return this == Constant.UNKNOWN_TYPE || otherType == Constant.UNKNOWN_TYPE || this.equals(otherType);
    }

    protected static boolean typesCompatible(Term type, Term type2) {
        if (type == Constant.UNKNOWN_TYPE || type2 == Constant.UNKNOWN_TYPE) {
            return true;
        }
        if (type instanceof Abstraction && type.countLambdas() == type2.countLambdas()) {
            return true;
        }
        return type.equals(type2);
    }

    public boolean hasBoundVar(int i) {
        return false;
    }

    public boolean hasBoundVarAbove(int i) {
        return false;
    }

    public final Set<FreeVar> getFreeVariables() {
        HashSet<FreeVar> s = new HashSet<FreeVar>();
        this.getFreeVariables(s);
        return s;
    }

    public final Term substitute(Substitution s) {
        return this.substitute(s, 0);
    }

    Term substitute(Substitution s, int varIncrAmount) {
        return this;
    }

    abstract void unifyCase(Term var1, Substitution var2, Queue<Pair<Term, Term>> var3);

    void unifyFlexApp(FreeVar function, List<? extends Term> arguments, Substitution current, Queue<Pair<Term, Term>> worklist) {
        Application errorApp = new Application((Atom)function, arguments);
        for (Term term : arguments) {
            if (term instanceof BoundVar) continue;
            throw new UnificationFailed("not implemented: non-pattern unification case after delay: " + errorApp + " and " + this, errorApp, this);
        }
        Term term = this;
        Term varType = function.getType();
        List<Term> argTypes = Term.getArgTypes(varType);
        Term term2 = Term.wrapWithLambdas(term, argTypes);
        current.add(function, term2);
        Term.unifyHelper(current, worklist);
    }

    public static Term wrapWithLambdas(Term termToWrap, List<Term> argTypes) {
        int i = argTypes.size() - 1;
        while (i >= 0) {
            termToWrap = Abstraction.make("x", argTypes.get(i), termToWrap);
            --i;
        }
        return termToWrap;
    }

    public static List<Term> getArgTypes(Term varType, int count) {
        ArrayList<Term> argTypes = new ArrayList<Term>();
        Util.debug("getting " + count + " args from " + varType);
        int i = 0;
        while (i < count) {
            argTypes.add(((Abstraction)varType).varType);
            varType = ((Abstraction)varType).getBody();
            ++i;
        }
        return argTypes;
    }

    public static List<Term> getArgTypes(Term varType) {
        ArrayList<Term> argTypes = new ArrayList<Term>();
        Util.debug("getting all args from " + varType);
        while (varType instanceof Abstraction) {
            argTypes.add(((Abstraction)varType).varType);
            varType = ((Abstraction)varType).getBody();
        }
        return argTypes;
    }

    public abstract Term apply(List<? extends Term> var1, int var2);

    final Term subForBoundVars(Map<Integer, Term> adjustmentMap) {
        int maxInt = 0;
        for (int i : adjustmentMap.keySet()) {
            if (i <= maxInt) continue;
            maxInt = i;
        }
        Term wrappedTerm = this;
        int i = 0;
        while (i < maxInt) {
            wrappedTerm = Facade.Abs(Constant.UNKNOWN_TYPE, wrappedTerm);
            ++i;
        }
        ArrayList<Term> argList = new ArrayList<Term>();
        int i2 = 0;
        while (i2 < maxInt) {
            if (adjustmentMap.get(i2) != null) {
                argList.add(adjustmentMap.get(i2));
            } else {
                argList.add(Facade.BVar(i2 + 1));
            }
            ++i2;
        }
        Term result = wrappedTerm.apply(argList, 0);
        Util.debug("\tadjusting " + this + " to " + result);
        return result;
    }

    Term incrFreeDeBruijn(int nested, int amount) {
        return this;
    }

    public final Term incrFreeDeBruijn(int amount) {
        return this.incrFreeDeBruijn(0, amount);
    }

    void getFreeVariables(Set<FreeVar> s) {
    }

    public int countLambdas() {
        return 0;
    }

    public abstract Term getType(List<Pair<String, Term>> var1);

    public void bindInFreeVars(Term typeTerm, Substitution sub) {
    }

    public void bindInFreeVars(Term typeTerm, Substitution sub, int i) {
    }

    public void bindInFreeVars(List<Term> typeTerms, Substitution sub, int idx) {
    }

    @Deprecated
    public Term oldBindInFreeVars(int i, Term typeTerm, Substitution sub) {
        return this;
    }

    @Deprecated
    public Term removeBoundVarsAbove(int i) {
        return this;
    }

    public void removeBoundVarsAbove(int i, Substitution sub) {
    }

    public FreeVar getEtaEquivFreeVar() {
        return null;
    }

    public Term toEtaLong() {
        return this;
    }

    static class PairComparator
    implements Comparator<Pair<Term, Term>> {
        PairComparator() {
        }

        @Override
        public int compare(Pair<Term, Term> t1, Pair<Term, Term> t2) {
            return ((Term)t1.first).oneIfNonPatFreeVarApp((Term)t1.second) - ((Term)t2.first).oneIfNonPatFreeVarApp((Term)t2.second);
        }
    }
}

