/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.EOCUnificationFailed;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Substitution {
    private Map<Atom, Term> varMap = new HashMap<Atom, Term>();
    private Map<Atom, Term> unmodifiableMap;

    public Substitution() {
    }

    public Substitution(Term term, Atom var) {
        this.add(var, term);
    }

    public Substitution(List<? extends Term> terms, List<Atom> vars) {
        if (terms.size() != vars.size()) {
            throw new RuntimeException("implementation error");
        }
        int i = 0;
        while (i < terms.size()) {
            this.add(vars.get(i), terms.get(i));
            ++i;
        }
    }

    public Substitution(Substitution other) {
        this.varMap.putAll(other.varMap);
    }

    public boolean isUnifier(Term t1, Term t2) {
        t1 = t1.substitute(this);
        t2 = t2.substitute(this);
        return t1.equals(t2);
    }

    public boolean avoid(Set<? extends Atom> atoms) {
        return this.selectUnavoidable(atoms).isEmpty();
    }

    public <T extends Atom> Set<T> selectUnavoidable(Set<T> vars) {
        HashSet<Atom> result = new HashSet<Atom>();
        for (Atom v : vars) {
            Term t = this.varMap.get(v);
            if (t == null) continue;
            FreeVar fv = t.getEtaEquivFreeVar();
            if (fv == null) {
                result.add(v);
                Util.debug("could not avoid " + v + " because it is equal to non-FreeVar expression " + t);
                continue;
            }
            if (vars.contains(fv)) {
                result.add(v);
                Util.debug("could not avoid " + v + " because it is equal to another thing we must avoid, " + fv);
                continue;
            }
            this.varMap.remove(v);
            this.add(fv, v);
        }
        return result;
    }

    public void add(Atom var, Term t) {
        Util.debug("substituting " + t + " for " + var + " adding to " + this);
        Term tSubstituted = this.varMap.isEmpty() ? t : t.substitute(this);
        FreeVar subFreeVar = tSubstituted.getEtaEquivFreeVar();
        if (tSubstituted.equals(var) || subFreeVar != null && subFreeVar.equals(var)) {
            return;
        }
        Util.debug("tSubstituted is " + tSubstituted);
        Set<FreeVar> freeVars = tSubstituted.getFreeVariables();
        if (freeVars.contains(var)) {
            throw new EOCUnificationFailed("Extended Occurs Check failed: " + var + " is free in " + tSubstituted, var);
        }
        if (!this.varMap.isEmpty()) {
            Substitution newSub = new Substitution(tSubstituted, var);
            for (Atom v : this.varMap.keySet()) {
                this.varMap.put(v, this.varMap.get(v).substitute(newSub));
            }
        }
        this.varMap.put(var, tSubstituted);
    }

    public Term getSubstituted(Atom var) {
        return this.varMap.get(var);
    }

    public void compose(Substitution other) {
        for (Atom v : other.varMap.keySet()) {
            this.add(v, other.varMap.get(v));
        }
    }

    public final void incrFreeDeBruijn(int amount) {
        for (Atom v : this.varMap.keySet()) {
            this.varMap.put(v, this.varMap.get(v).incrFreeDeBruijn(amount));
        }
    }

    public Map<Atom, Term> getMap() {
        if (this.unmodifiableMap == null) {
            this.unmodifiableMap = Collections.unmodifiableMap(this.varMap);
        }
        return this.unmodifiableMap;
    }

    public int hashCode() {
        return this.varMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Substitution)) {
            return false;
        }
        Substitution s = (Substitution)obj;
        return this.varMap.equals(s.varMap);
    }

    public String toString() {
        return this.getMap().toString();
    }
}

