/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.BoundVar;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.Relation;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class FreeVar
extends Atom {
    private int stamp;
    private Term type;
    static int freshStamp = 1;
    private static Relation<Term, Term> appearsIn = new Relation();

    public FreeVar(String n, Term t, int s) {
        super(n);
        this.type = t;
        this.stamp = s;
    }

    public FreeVar(String n, Term t) {
        this(n, t, 0);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && ((FreeVar)obj).stamp == this.stamp;
    }

    public static FreeVar fresh(String s, Term t) {
        FreeVar newV = new FreeVar(s, t, freshStamp++);
        return newV;
    }

    public FreeVar freshify() {
        FreeVar newV = new FreeVar(this.getName(), this.type, freshStamp++);
        return newV;
    }

    @Override
    public String toString() {
        if (this.stamp == 0) {
            return this.getName();
        }
        return String.valueOf(this.getName()) + "_" + this.stamp;
    }

    @Override
    int getOrder() {
        return 0;
    }

    @Override
    boolean isNonPatFreeVarApp(Term other) {
        return other.isNonPatFreeVarApp();
    }

    @Override
    void unifyCase(Term other, Substitution current, Queue<Pair<Term, Term>> worklist) {
        Term t = current.getMap().get(this);
        if (t != null) {
            worklist.add(FreeVar.makePair(t, other));
            Term.unifyHelper(current, worklist);
        } else {
            if (!this.equals(other)) {
                if (other instanceof Application && ((Application)other).isPattern()) {
                    FreeVar otherVar = (FreeVar)((Application)other).getFunction();
                    if (current.getMap().get(otherVar) != null) {
                        Term newOther = other.substitute(current);
                        worklist.add(FreeVar.makePair(this, newOther));
                        Term.unifyHelper(current, worklist);
                    } else {
                        Term varMatch = this;
                        List<Term> otherVarArgTypes = FreeVar.getArgTypes(otherVar.getType(), ((Application)other).getArguments().size());
                        varMatch = FreeVar.wrapWithLambdas(varMatch, otherVarArgTypes);
                        current.add(otherVar, varMatch);
                    }
                } else {
                    current.add(this, other);
                }
            }
            Term.unifyHelper(current, worklist);
        }
    }

    @Override
    void unifyFlexApp(FreeVar function, List<? extends Term> arguments, Substitution current, Queue<Pair<Term, Term>> worklist) {
        throw new RuntimeException("internal invariant violated");
    }

    @Override
    void getFreeVariables(Set<FreeVar> s) {
        s.add(this);
    }

    public Term getBaseType() {
        Term baseType = this.type;
        while (baseType instanceof Abstraction) {
            baseType = ((Abstraction)baseType).getBody();
        }
        return baseType;
    }

    @Override
    public Term getType() {
        return this.type;
    }

    public void setType(Term varType) {
        this.type = varType;
    }

    @Override
    public void bindInFreeVars(Term typeTerm, Substitution sub) {
        Term earlierSub = sub.getSubstituted(this);
        if (earlierSub != null) {
            return;
        }
        Term baseType = this.getBaseType();
        if (!FreeVar.canAppearIn(typeTerm, baseType)) {
            return;
        }
        FreeVar newVar = this.freshify();
        newVar.type = Abstraction.make("extendedTypeArg", typeTerm, this.type);
        Application appTerm = new Application((Atom)newVar, new BoundVar(1));
        sub.add(this, appTerm);
    }

    @Override
    public void bindInFreeVars(List<Term> typeTerms, Substitution sub, int idx) {
        Term earlierSub = sub.getSubstituted(this);
        if (earlierSub != null || typeTerms.size() == 0) {
            return;
        }
        Term baseType = this.getBaseType();
        Term newVarType = this.type;
        ArrayList<Term> bVarList = new ArrayList<Term>();
        int currIdx = idx + typeTerms.size();
        for (Term typeTerm : typeTerms) {
            --currIdx;
            if (!FreeVar.canAppearIn(typeTerm, baseType)) continue;
            newVarType = Abstraction.make("extendedTypeArg", typeTerm, newVarType);
            bVarList.add(new BoundVar(currIdx));
        }
        if (bVarList.size() == 0) {
            return;
        }
        FreeVar newVar = this.freshify();
        newVar.type = newVarType;
        Application appTerm = Facade.App((Atom)newVar, bVarList);
        sub.add(this, appTerm);
    }

    @Override
    public void bindInFreeVars(Term typeTerm, Substitution sub, int i) {
        Term earlierSub = sub.getSubstituted(this);
        if (earlierSub != null) {
            return;
        }
        Term baseType = this.getBaseType();
        if (!FreeVar.canAppearIn(typeTerm, baseType)) {
            return;
        }
        FreeVar newVar = this.freshify();
        newVar.type = Abstraction.make("extendedTypeArg", typeTerm, this.type);
        Application appTerm = new Application((Atom)newVar, new BoundVar(i));
        sub.add(this, appTerm);
    }

    @Override
    @Deprecated
    public Term oldBindInFreeVars(int i, Term typeTerm, Substitution sub) {
        Term earlierSub = sub.getSubstituted(this);
        if (earlierSub != null) {
            return earlierSub;
        }
        Term baseType = this.getBaseType();
        if (!FreeVar.canAppearIn(typeTerm, baseType)) {
            return this;
        }
        FreeVar newVar = this.freshify();
        newVar.type = Abstraction.make("extendedTypeArg", typeTerm, this.type);
        Application appTerm = new Application((Atom)newVar, new BoundVar(i));
        sub.add(this, appTerm);
        return appTerm;
    }

    public static boolean canAppearIn(Term term1, Term term2) {
        Util.debug("testing if " + term1 + " can appear in " + term2);
        return appearsIn.contains(term1, term2);
    }

    public static void setAppearsIn(Term term1, Term term2) {
        boolean changed = appearsIn.put(term1, term2);
        if (changed) {
            FreeVar.enforceTransitivity(term1, term2);
        }
    }

    private static void enforceTransitivity(Term t1, Term t2) {
        Util.debug("added " + t1 + " in " + t2);
        Set<Term> t3set = appearsIn.getAll(t2);
        for (Term t3 : t3set) {
            if (!FreeVar.canAppearIn(t1, t3)) {
                Util.debug("transitivity: " + t1 + " in " + t2 + " in " + t3);
            }
            FreeVar.setAppearsIn(t1, t3);
        }
        Set<Term> t0set = appearsIn.getAllReverse(t1);
        for (Term t0 : t0set) {
            if (!FreeVar.canAppearIn(t0, t2)) {
                Util.debug("transitivityBack: " + t0 + " in " + t1 + " in " + t2);
            }
            FreeVar.setAppearsIn(t0, t2);
        }
    }

    public static void reinit() {
        appearsIn = new Relation();
    }

    public static void computeAppearsInClosure() {
    }

    @Override
    public FreeVar getEtaEquivFreeVar() {
        return this;
    }

    @Override
    public Term toEtaLong() {
        int numLambdas = this.getType().countLambdas();
        if (numLambdas > 0) {
            ArrayList<BoundVar> args = new ArrayList<BoundVar>();
            ArrayList<Term> types = new ArrayList<Term>();
            Term myType = this.getType();
            int i = numLambdas;
            while (i > 0) {
                args.add(new BoundVar(i));
                Abstraction abs = (Abstraction)myType;
                types.add(abs.varType);
                myType = abs.getBody();
                --i;
            }
            Term newT = this.apply(args, 0);
            int i2 = numLambdas - 1;
            while (i2 >= 0) {
                newT = Facade.Abs((Term)types.get(i2), newT);
                --i2;
            }
            Util.debug("converted to eta long - from " + this + " to " + newT);
            return newT;
        }
        return this;
    }
}

