/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.Util;
import java.util.List;
import java.util.Queue;

public class BoundVar
extends Term {
    private int index;

    public BoundVar(int index) {
        if (index <= 0) {
            Util.debug("warning: de bruijn indexes are generally positive - exceptions only for substitutions that capture vars");
        }
        this.index = index;
    }

    public int hashCode() {
        return this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BoundVar)) {
            return false;
        }
        BoundVar bv = (BoundVar)obj;
        return bv.index == this.index;
    }

    public String toString() {
        return "BoundVar" + this.index;
    }

    @Override
    Term incrFreeDeBruijn(int nested, int amount) {
        if (this.index <= nested && this.index > 0) {
            return this;
        }
        return new BoundVar(this.index + amount);
    }

    @Override
    public boolean hasBoundVar(int i) {
        return this.index == i;
    }

    @Override
    public boolean hasBoundVarAbove(int i) {
        return this.index > i;
    }

    @Override
    public Term removeBoundVarsAbove(int i) {
        if (this.index > i) {
            throw new UnificationFailed("could not eliminate variable binding");
        }
        return this;
    }

    @Override
    public void removeBoundVarsAbove(int i, Substitution sub) {
        if (this.index > i) {
            throw new UnificationFailed("could not eliminate variable binding");
        }
    }

    @Override
    public Term apply(List<? extends Term> arguments, int whichApplied) {
        Util.verify(whichApplied >= arguments.size(), "type invariant broken in term system");
        int argIndex = whichApplied - this.index;
        if (argIndex >= 0 && argIndex < arguments.size()) {
            Term result = arguments.get(argIndex);
            return result;
        }
        return this;
    }

    @Override
    void unifyCase(Term other, Substitution current, Queue<Pair<Term, Term>> worklist) {
        if (!this.equals(other)) {
            throw new UnificationFailed("Atoms differ: " + this + " and " + other, this, other);
        }
        Term.unifyHelper(current, worklist);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void unifyFlexApp(FreeVar function, List<? extends Term> arguments, Substitution current, Queue<Pair<Term, Term>> worklist) {
        void var6_9;
        Application errorApp = new Application((Atom)function, arguments);
        for (Term term : arguments) {
            if (term instanceof BoundVar) continue;
            throw new UnificationFailed("not implemented: non-pattern unification case after delay: " + errorApp + " and " + this, errorApp, this);
        }
        boolean bl = true;
        while (var6_9 <= arguments.size()) {
            if (this.equals(arguments.get(arguments.size() - var6_9))) break;
            ++var6_9;
        }
        if (var6_9 == arguments.size() + 1) {
            throw new UnificationFailed("cannot unify " + this + " with expression " + errorApp + " in which var is not free", errorApp, this);
        }
        Term wrappedBVar = new BoundVar((int)var6_9);
        Term varType = function.getType();
        List<Term> argTypes = BoundVar.getArgTypes(varType);
        wrappedBVar = BoundVar.wrapWithLambdas(wrappedBVar, argTypes);
        current.add(function, wrappedBVar);
        BoundVar.unifyHelper(current, worklist);
    }

    @Override
    public Term getType(List<Pair<String, Term>> varBindings) {
        int indexToUse = varBindings.size() - this.index;
        if (indexToUse < 0 || indexToUse >= varBindings.size()) {
            return Constant.UNKNOWN_TYPE;
        }
        return (Term)varBindings.get((int)indexToUse).second;
    }
}

