/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import java.util.List;

public abstract class Atom
extends Term {
    private String name;

    protected Atom(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final Term getType(List<Pair<String, Term>> varBindings) {
        return this.getType();
    }

    public abstract Term getType();

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Atom)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Atom a = (Atom)obj;
        return this.name.equals(a.name);
    }

    @Override
    public Term apply(List<? extends Term> arguments, int whichApplied) {
        if (whichApplied < arguments.size()) {
            return new Application(this, arguments.subList(whichApplied, arguments.size()));
        }
        return this;
    }

    @Override
    Term substitute(Substitution s, int varIncrAmount) {
        Term t = s.getSubstituted(this);
        if (t != null) {
            return t.incrFreeDeBruijn(varIncrAmount);
        }
        return this;
    }

    public String toString() {
        return this.name;
    }
}

