/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.BoundVar;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class Application
extends Term {
    private Atom function;
    private List<? extends Term> arguments;

    public Application(Atom f, List<? extends Term> a) {
        this.function = f;
        this.arguments = a;
        boolean convertFlag = false;
        for (Term term : this.arguments) {
            if (!(term instanceof FreeVar) || ((FreeVar)term).getType().countLambdas() <= 0) continue;
            convertFlag = true;
        }
        if (convertFlag) {
            ArrayList<? extends Term> arrayList = new ArrayList<Term>();
            for (Term term : a) {
                arrayList.add(term.toEtaLong());
            }
            this.arguments = arrayList;
        }
        this.getType(new ArrayList<Pair<String, Term>>());
        if (a.size() == 0) {
            throw new RuntimeException("empty application args");
        }
    }

    public Application(Atom f, Term a) {
        this(f, Arrays.asList(a));
    }

    public Atom getFunction() {
        return this.function;
    }

    public List<? extends Term> getArguments() {
        return this.arguments;
    }

    @Override
    Term substitute(Substitution s, int varIncrAmount) {
        Term newF = this.function.substitute(s, varIncrAmount);
        ArrayList<Term> newArgs = new ArrayList<Term>();
        boolean isNew = false;
        for (Term term : this.arguments) {
            Term t = term.substitute(s, varIncrAmount);
            newArgs.add(t);
            if (t == term) continue;
            isNew = true;
        }
        if (isNew || this.function != newF) {
            return newF.apply(newArgs, 0);
        }
        return this;
    }

    @Override
    public Term apply(List<? extends Term> otherArgs, int whichApplied) {
        Atom newFunction = this.function;
        ArrayList<? extends Term> newArgs = new ArrayList<Term>(this.arguments);
        if (whichApplied > 0) {
            int i = 0;
            while (i < newArgs.size()) {
                newArgs.set(i, ((Term)newArgs.get(i)).apply(otherArgs.subList(0, Math.min(otherArgs.size(), whichApplied)), whichApplied));
                ++i;
            }
            newFunction = (Atom)newFunction.apply(otherArgs.subList(0, Math.min(otherArgs.size(), whichApplied)), whichApplied);
        }
        newArgs.addAll(otherArgs.subList(Math.min(otherArgs.size(), whichApplied), otherArgs.size()));
        return new Application(newFunction, newArgs);
    }

    @Override
    Term incrFreeDeBruijn(int nested, int amount) {
        ArrayList<Term> newArgs = new ArrayList<Term>();
        boolean isNew = false;
        for (Term term : this.arguments) {
            Term t = term.incrFreeDeBruijn(nested, amount);
            newArgs.add(t);
            if (t == term) continue;
            isNew = true;
        }
        if (isNew) {
            return new Application(this.function, newArgs);
        }
        return this;
    }

    @Override
    public boolean hasBoundVar(int i) {
        boolean result = this.function.hasBoundVar(i);
        for (Term term : this.arguments) {
            boolean bl = result = result || term.hasBoundVar(i);
        }
        return result;
    }

    @Override
    public boolean hasBoundVarAbove(int i) {
        boolean result = this.function.hasBoundVarAbove(i);
        for (Term term : this.arguments) {
            boolean bl = result = result || term.hasBoundVarAbove(i);
        }
        return result;
    }

    @Override
    void getFreeVariables(Set<FreeVar> s) {
        this.function.getFreeVariables(s);
        for (Term term : this.arguments) {
            term.getFreeVariables(s);
        }
    }

    @Override
    int getOrder() {
        return 1 + this.function.getOrder() / 2;
    }

    @Override
    boolean isNonPatFreeVarApp() {
        if (this.function instanceof FreeVar) {
            for (Term term : this.arguments) {
                if (term instanceof BoundVar) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isNonPatFreeVarApp(Term other) {
        if (this.function instanceof FreeVar) {
            for (Term term : this.arguments) {
                if (term instanceof BoundVar) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isPattern(Term f, List<? extends Term> args) {
        if (f instanceof FreeVar) {
            for (Term term : args) {
                if (term instanceof BoundVar) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isPattern() {
        return Application.isPattern(this.function, this.arguments);
    }

    @Override
    void unifyCase(Term other, Substitution current, Queue<Pair<Term, Term>> worklist) {
        if (this.function instanceof Constant) {
            if (!(other instanceof Application) || ((Application)other).arguments.size() != this.arguments.size()) {
                throw new UnificationFailed(String.valueOf(this.toString()) + " and " + other, this, other);
            }
            Application otherApp = (Application)other;
            worklist.add(Application.makePair(this.function, otherApp.function));
            int i = 0;
            while (i < this.arguments.size()) {
                worklist.add(Application.makePair(this.arguments.get(i), otherApp.arguments.get(i)));
                ++i;
            }
            Application.unifyHelper(current, worklist);
        } else {
            FreeVar functionVar = (FreeVar)this.function;
            Term t = current.getMap().get(functionVar);
            if (t != null) {
                worklist.add(Application.makePair(t.apply(this.arguments, 0), other));
                Application.unifyHelper(current, worklist);
            } else {
                other.unifyFlexApp((FreeVar)this.function, this.arguments, current, worklist);
            }
        }
    }

    @Override
    void unifyFlexApp(FreeVar otherVar, List<? extends Term> otherArgs, Substitution current, Queue<Pair<Term, Term>> worklist) {
        if (this.function instanceof Constant) {
            if (this.getFreeVariables().contains(otherVar)) {
                Application errorApp = new Application((Atom)otherVar, otherArgs);
                throw new UnificationFailed("recursion detected", errorApp, this);
            }
            HashMap<Integer, Term> adjustmentMap = new HashMap<Integer, Term>();
            int i = 0;
            while (i < otherArgs.size()) {
                BoundVar bv;
                int j;
                int iAsIndex;
                if (otherArgs.get(i) instanceof BoundVar && (iAsIndex = i + 1) != (j = (bv = (BoundVar)otherArgs.get(i)).getIndex())) {
                    Util.debug("adjusting " + j + " to " + iAsIndex + " in " + otherArgs);
                    adjustmentMap.put(j, Facade.BVar(iAsIndex));
                }
                ++i;
            }
            Constant constant = (Constant)this.function;
            ArrayList<Term> newArgs = new ArrayList<Term>();
            Term partialFunctionType = constant.getType();
            List<Term> otherVarArgTypes = Application.getArgTypes(otherVar.getType(), otherArgs.size());
            int i2 = 0;
            while (i2 < this.arguments.size()) {
                Term newVarType = Application.wrapWithLambdas(((Abstraction)partialFunctionType).varType, otherVarArgTypes);
                partialFunctionType = ((Abstraction)partialFunctionType).getBody();
                FreeVar newVar = FreeVar.fresh("none", newVarType);
                Application argApp = new Application((Atom)newVar, otherArgs);
                Term adjustedApp = argApp.subForBoundVars(adjustmentMap);
                newArgs.add(adjustedApp);
                worklist.add(Application.makePair(argApp, this.arguments.get(i2)));
                ++i2;
            }
            Term varMatch = new Application((Atom)constant, newArgs);
            varMatch = Application.wrapWithLambdas(varMatch, otherVarArgTypes);
            current.add(otherVar, varMatch);
            Application.unifyHelper(current, worklist);
        } else {
            FreeVar functionVar = (FreeVar)this.function;
            Term t = current.getMap().get(functionVar);
            if (t != null) {
                worklist.add(Application.makePair(t.apply(this.arguments, 0), otherVar.apply(otherArgs, 0)));
                Application.unifyHelper(current, worklist);
                return;
            }
            if (otherVar.equals(this.function.substitute(current))) {
                Util.verify(this.arguments.size() == otherArgs.size(), "internal invariant: args to var must be of equal length");
                int i = 0;
                while (i < this.arguments.size()) {
                    worklist.add(Application.makePair(otherArgs.get(i), this.arguments.get(i)));
                    ++i;
                }
                Application.unifyHelper(current, worklist);
            } else {
                Application errorApp = new Application((Atom)otherVar, otherArgs);
                if (!errorApp.isPattern()) {
                    errorApp.tryEtaLongCase(this, current, worklist);
                    return;
                }
                if (!this.isPattern()) {
                    this.tryEtaLongCase(errorApp, current, worklist);
                    return;
                }
                ArrayList<? extends Term> commonArgs = new ArrayList<Term>(this.arguments);
                List<Term> functionArgTypes = Application.getArgTypes(this.function.getType(), this.arguments.size());
                Term residualType = this.function.getType();
                int i = 0;
                while (i < commonArgs.size()) {
                    Term arg = (Term)commonArgs.get(i);
                    if (otherArgs.contains(arg)) {
                        ++i;
                    } else {
                        commonArgs.remove(i);
                        functionArgTypes.remove(i);
                    }
                    residualType = ((Abstraction)residualType).getBody();
                }
                Term HType = Application.wrapWithLambdas(residualType, functionArgTypes);
                FreeVar H = FreeVar.fresh("H", HType);
                Term varMatch = this.computeVarMatch(H, commonArgs, this.arguments, Application.getArgTypes(this.function.getType(), this.arguments.size()), current, errorApp);
                Term otherVarMatch = this.computeVarMatch(H, commonArgs, otherArgs, Application.getArgTypes(otherVar.getType(), otherArgs.size()), current, errorApp);
                current.add(this.function, varMatch);
                current.add(otherVar, otherVarMatch);
                Application.unifyHelper(current, worklist);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryEtaLongCase(Application application, Substitution current, Queue<Pair<Term, Term>> worklist) {
        int sizeDelta = this.arguments.size() - application.arguments.size();
        if (sizeDelta > 0) {
            boolean argTailIdentical = true;
            int i = 0;
            while (i < application.arguments.size()) {
                if (!this.arguments.get(i + sizeDelta).equals(application.arguments.get(i))) {
                    argTailIdentical = false;
                }
                ++i;
            }
            Application thePattern = null;
            Application theOther = null;
            if (this.isPattern()) {
                thePattern = this;
                theOther = application;
            }
            if (application.isPattern()) {
                thePattern = application;
                theOther = this;
            }
            if (thePattern != null) {
                void var11_25;
                void var11_22;
                ArrayList<? extends Term> patternArgs = new ArrayList<Term>(thePattern.getArguments());
                int maxIndex = ((BoundVar)patternArgs.get(0)).getIndex();
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (BoundVar boundVar : patternArgs) {
                    int index = boundVar.getIndex();
                    indexes.add(index);
                    if (index <= maxIndex) continue;
                    maxIndex = index;
                }
                Application application2 = theOther;
                int i2 = 0;
                while (i2 < maxIndex) {
                    Term term = Abstraction.make("x", Constant.UNKNOWN_TYPE, (Term)var11_22);
                    ++i2;
                }
                ArrayList<BoundVar> argList = new ArrayList<BoundVar>();
                int i3 = 0;
                while (i3 < maxIndex) {
                    if (indexes.contains(i3)) {
                        int currIndex = indexes.indexOf(i3);
                        argList.add(Facade.BVar(currIndex));
                    } else {
                        argList.add(Facade.BVar(i3 + indexes.size()));
                    }
                    ++i3;
                }
                Term term = var11_22.apply(argList, 0);
                List<Term> functionArgTypes = Application.getArgTypes(thePattern.getFunction().getType(), thePattern.getArguments().size());
                int i4 = 0;
                while (i4 < patternArgs.size()) {
                    Term term2 = Abstraction.make("x", functionArgTypes.get(i4), (Term)var11_25);
                    ++i4;
                }
                current.add(thePattern.getFunction(), (Term)var11_25);
                Application.unifyHelper(current, worklist);
                return;
            } else {
                if (!argTailIdentical) throw new UnificationFailed("not implemented: non-pattern unification case after delay: " + application + " and " + this, application, this);
                FreeVar otherVar = (FreeVar)application.function;
                ArrayList<Term> myNewArgs = new ArrayList<Term>();
                int i5 = 0;
                while (i5 < sizeDelta) {
                    myNewArgs.add(this.arguments.get(i5));
                    ++i5;
                }
                Application newMe = (Application)this.function.apply(myNewArgs, 0);
                Util.debug("fixing up eta long case in pattern unification: " + otherVar + " ==> " + newMe);
                current.add(otherVar, newMe);
                Application.unifyHelper(current, worklist);
            }
            return;
        } else {
            worklist.add(Application.makePair(this.function, application.function));
            int i = 0;
            while (i < this.arguments.size()) {
                worklist.add(Application.makePair(application.arguments.get(i), this.arguments.get(i)));
                ++i;
            }
            Application.unifyHelper(current, worklist);
        }
    }

    private Term computeVarMatch(FreeVar H, List<BoundVar> commonArgs, List<BoundVar> arguments2, List<Term> arguments2Types, Substitution current, Application errorApp) {
        ArrayList<Term> substitutedOtherArgs = new ArrayList<Term>();
        for (Term term : arguments2) {
            substitutedOtherArgs.add(term.substitute(current));
        }
        ArrayList<BoundVar> arrayList = new ArrayList<BoundVar>();
        for (Term term : commonArgs) {
            Term term2 = term.substitute(current);
            int foundIndex = substitutedOtherArgs.indexOf(term2);
            if (foundIndex == -1) {
                throw new UnificationFailed(String.valueOf(this.toString()) + " is not an instance of " + errorApp + ": could not find argument " + term2, errorApp, this);
            }
            int newIndex = arguments2.size() - foundIndex;
            arrayList.add(new BoundVar(newIndex));
        }
        Term term3 = arrayList.isEmpty() ? H : new Application((Atom)H, arrayList);
        term3 = Application.wrapWithLambdas(term3, arguments2Types);
        return term3;
    }

    public int hashCode() {
        return this.function.hashCode() + this.arguments.hashCode();
    }

    @Override
    public boolean typeEquals(Term otherType) {
        if (super.typeEquals(otherType)) {
            return true;
        }
        if (!(otherType instanceof Application)) {
            return false;
        }
        Application a = (Application)otherType;
        if (this.arguments.size() != a.arguments.size()) {
            return false;
        }
        int i = 0;
        while (i < this.arguments.size()) {
            if (!this.arguments.get(i).typeEquals(a.arguments.get(i))) {
                return false;
            }
            ++i;
        }
        return this.function.typeEquals(a.function);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Application a = (Application)obj;
        return this.function.equals(a.function) && this.arguments.equals(a.arguments);
    }

    public String toString() {
        return "(" + this.function + " " + this.arguments + ")";
    }

    @Override
    public Term getType(List<Pair<String, Term>> varBindings) {
        Term funType = this.function.getType(varBindings);
        for (Term term : this.arguments) {
            Term absType;
            if (!(funType instanceof Abstraction)) {
                Util.verify(false, "applied " + this.arguments.size() + " arguments to function " + this.function + " of type " + this.function.getType(varBindings));
            }
            Abstraction funTypeAbs = (Abstraction)funType;
            Term argType = term.getType(varBindings);
            Util.verify(argType.typeEquals(absType = funTypeAbs.varType) || this.function.toString().contains("TERM"), "types do not match when applying " + argType + " to arg type " + absType + " in function " + this.function);
            funType = funTypeAbs.getBody();
        }
        return funType;
    }

    @Override
    public void bindInFreeVars(Term typeTerm, Substitution sub) {
        this.function.bindInFreeVars(typeTerm, sub);
        for (Term term : this.arguments) {
            term.bindInFreeVars(typeTerm, sub);
        }
    }

    @Override
    public void bindInFreeVars(Term typeTerm, Substitution sub, int i) {
        this.function.bindInFreeVars(typeTerm, sub, i);
        for (Term term : this.arguments) {
            term.bindInFreeVars(typeTerm, sub, i);
        }
    }

    @Override
    public void bindInFreeVars(List<Term> typeTerms, Substitution sub, int idx) {
        this.function.bindInFreeVars(typeTerms, sub, idx);
        for (Term term : this.arguments) {
            term.bindInFreeVars(typeTerms, sub, idx);
        }
    }

    @Override
    @Deprecated
    public Term oldBindInFreeVars(int i, Term typeTerm, Substitution sub) {
        boolean isNew = false;
        Term newFunction = this.function.oldBindInFreeVars(i, typeTerm, sub);
        if (newFunction != this.function) {
            isNew = true;
        }
        ArrayList<Term> newArgs = new ArrayList<Term>();
        for (Term term : this.arguments) {
            Term t = term.oldBindInFreeVars(i, typeTerm, sub);
            newArgs.add(t);
            if (t == term) continue;
            isNew = true;
        }
        if (isNew) {
            return newFunction.apply(newArgs, 0);
        }
        return this;
    }

    @Override
    @Deprecated
    public Term removeBoundVarsAbove(int i) {
        Term newFunction;
        ArrayList<? extends Term> newArgs;
        boolean isNew = false;
        Atom theFunction = this.function;
        List<? extends Term> theArguments = this.arguments;
        if (theFunction instanceof FreeVar) {
            List<Term> argTypes = Application.getArgTypes(theFunction.getType());
            newArgs = new ArrayList<Term>();
            ArrayList<Term> arrayList = new ArrayList<Term>();
            int j = 0;
            while (j < theArguments.size()) {
                Term a = theArguments.get(j);
                if (!(a instanceof BoundVar) || ((BoundVar)a).getIndex() <= i) {
                    newArgs.add(a);
                    arrayList.add(argTypes.get(j));
                }
                ++j;
            }
            if (newArgs.size() != theArguments.size()) {
                Term newType = Application.wrapWithLambdas(((FreeVar)theFunction).getBaseType(), arrayList);
                theFunction = Facade.FreshVar(((FreeVar)theFunction).getName(), newType);
                theArguments = newArgs;
                isNew = true;
            }
        }
        if ((newFunction = theFunction.removeBoundVarsAbove(i)) != theFunction) {
            isNew = true;
        }
        newArgs = new ArrayList();
        for (Term term : theArguments) {
            Term t = term.removeBoundVarsAbove(i);
            newArgs.add(t);
            if (t == term) continue;
            isNew = true;
        }
        if (isNew) {
            return newFunction.apply(newArgs, 0);
        }
        return this;
    }

    @Override
    public void removeBoundVarsAbove(int i, Substitution sub) {
        Atom theFunction = this.function;
        List<? extends Term> theArguments = this.arguments;
        if (theFunction instanceof FreeVar) {
            if (sub.getSubstituted(theFunction) != null) {
                sub.getSubstituted(theFunction).apply(this.arguments, 0).removeBoundVarsAbove(i, sub);
                return;
            }
            List<Term> list = Application.getArgTypes(theFunction.getType());
            ArrayList<? extends Term> newArgs = new ArrayList<Term>();
            ArrayList<Term> newArgTypes = new ArrayList<Term>();
            int j = 0;
            while (j < theArguments.size()) {
                Term a = theArguments.get(j);
                if (!(a instanceof BoundVar) || ((BoundVar)a).getIndex() <= i) {
                    newArgs.add(a);
                    newArgTypes.add(list.get(j));
                }
                ++j;
            }
            if (newArgs.size() != theArguments.size()) {
                Term newType = Application.wrapWithLambdas(((FreeVar)theFunction).getBaseType(), newArgTypes);
                theFunction = Facade.FreshVar(((FreeVar)theFunction).getName(), newType);
                theArguments = newArgs;
                Term newTerm = theFunction.apply(theArguments, 0);
                newTerm = Term.wrapWithLambdas(newTerm, list);
                sub.add(this.function, newTerm);
            }
        }
        theFunction.removeBoundVarsAbove(i, sub);
        for (Term term : theArguments) {
            term.removeBoundVarsAbove(i, sub);
        }
    }

    public boolean isFullyAppliedFreeVar() {
        if (this.function instanceof FreeVar) {
            int numTypeLambdas = this.function.getType().countLambdas();
            return this.arguments.size() == numTypeLambdas;
        }
        return false;
    }
}

