/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.term;

import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.BoundVar;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class Abstraction
extends Term {
    public Term varType;
    public String varName;
    private Term body;

    public static Term make(String var, Term type, Term body) {
        if (body instanceof Application && !((Application)body).isFullyAppliedFreeVar()) {
            Application bodyApp = (Application)body;
            List<? extends Term> args = bodyApp.getArguments();
            Term lastArg = args.get(args.size() - 1);
            if (bodyApp.getFunction() instanceof FreeVar && lastArg instanceof BoundVar && ((BoundVar)lastArg).getIndex() == 1) {
                Term result;
                if (args.size() == 1) {
                    result = bodyApp.getFunction();
                } else {
                    ArrayList<? extends Term> newArgs = new ArrayList<Term>(args);
                    newArgs.remove(newArgs.size() - 1);
                    result = new Application(bodyApp.getFunction(), newArgs);
                }
                if (!result.hasBoundVar(1)) {
                    return result.incrFreeDeBruijn(0, -1);
                }
            }
        }
        return new Abstraction(var, type, body);
    }

    private Abstraction(String name, Term type, Term b) {
        this.varName = name;
        this.varType = type;
        this.body = b;
        if (b instanceof Application && !((Application)b).isFullyAppliedFreeVar()) {
            Application bodyApp = (Application)this.body;
            List<? extends Term> args = bodyApp.getArguments();
            Term lastArg = args.get(args.size() - 1);
            if (bodyApp.getFunction() instanceof FreeVar && lastArg instanceof BoundVar && ((BoundVar)lastArg).getIndex() == 1) {
                boolean hasBoundVar = bodyApp.getFunction().hasBoundVar(1);
                int i = 0;
                while (i < args.size() - 1) {
                    hasBoundVar = hasBoundVar || args.get(i).hasBoundVar(1);
                    ++i;
                }
                Util.verify(hasBoundVar, "non-eta-normal term");
            }
        }
    }

    @Override
    Term substitute(Substitution s, int varIncrAmount) {
        Term newBody = this.body.substitute(s, varIncrAmount + 1);
        Term newType = this.varType.substitute(s, varIncrAmount);
        if (newBody == this.body && newType == this.varType) {
            return this;
        }
        return Abstraction.make(this.varName, newType, newBody);
    }

    @Override
    void getFreeVariables(Set<FreeVar> s) {
        this.body.getFreeVariables(s);
        this.varType.getFreeVariables(s);
    }

    @Override
    void unifyCase(Term other, Substitution current, Queue<Pair<Term, Term>> worklist) {
        if (other instanceof Abstraction) {
            FreeVar myVar = this.getEtaEquivFreeVar();
            FreeVar otherVar = other.getEtaEquivFreeVar();
            if (myVar != null || otherVar != null) {
                worklist.add(Abstraction.makePair(myVar == null ? this : myVar, otherVar == null ? other : otherVar));
            } else {
                worklist.add(Abstraction.makePair(this.body, ((Abstraction)other).body));
                worklist.add(Abstraction.makePair(this.varType, ((Abstraction)other).varType));
            }
        } else {
            throw new UnificationFailed(String.valueOf(other.toString()) + " is not an instance of " + this + " (may need to implement eta-normalization)", this, other);
        }
        Abstraction.unifyHelper(current, worklist);
    }

    @Override
    void unifyFlexApp(FreeVar function, List<? extends Term> arguments, Substitution current, Queue<Pair<Term, Term>> worklist) {
        ArrayList<Term> newArgs = new ArrayList<Term>();
        for (Term term : arguments) {
            newArgs.add(term.incrFreeDeBruijn(0, 1));
        }
        newArgs.add(new BoundVar(1));
        Application application = new Application((Atom)function, newArgs);
        worklist.add(Abstraction.makePair(application, this.body));
        Abstraction.unifyHelper(current, worklist);
    }

    @Override
    public Term apply(List<? extends Term> arguments, int whichApplied) {
        ++whichApplied;
        ArrayList<Term> newArgs = new ArrayList<Term>();
        for (Term term : arguments) {
            newArgs.add(term.incrFreeDeBruijn(1));
        }
        Term term = this.body.apply(newArgs, whichApplied);
        if (whichApplied <= arguments.size()) {
            return term.incrFreeDeBruijn(-1);
        }
        if (term == this.body) {
            return this;
        }
        return Abstraction.make(this.varName, this.varType, term);
    }

    @Override
    Term incrFreeDeBruijn(int nested, int amount) {
        Term newBody = this.body.incrFreeDeBruijn(nested + 1, amount);
        Term newType = this.varType.incrFreeDeBruijn(nested, amount);
        if (newBody == this.body && newType == this.varType) {
            return this;
        }
        return Abstraction.make(this.varName, newType, newBody);
    }

    @Override
    public boolean hasBoundVar(int i) {
        return this.body.hasBoundVar(i + 1) || this.varType.hasBoundVar(i);
    }

    @Override
    public boolean hasBoundVarAbove(int i) {
        return this.body.hasBoundVarAbove(i + 1) || this.varType.hasBoundVarAbove(i);
    }

    public int hashCode() {
        return this.body.hashCode();
    }

    @Override
    public boolean typeEquals(Term otherType) {
        if (super.typeEquals(otherType)) {
            return true;
        }
        if (!(otherType instanceof Abstraction)) {
            return false;
        }
        Abstraction a = (Abstraction)otherType;
        return this.body.typeEquals(a.body) && this.varType.typeEquals(a.varType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Abstraction)) {
            return false;
        }
        Abstraction a = (Abstraction)obj;
        return this.body.equals(a.body) && this.varType.typeEquals(a.varType);
    }

    public String toString() {
        return "fn " + this.varName + ":" + this.varType + " => " + this.body;
    }

    @Override
    public int countLambdas() {
        return this.body.countLambdas() + 1;
    }

    @Override
    public Term getType(List<Pair<String, Term>> varBindings) {
        ArrayList<Pair<String, Term>> newBindings = new ArrayList<Pair<String, Term>>(varBindings);
        newBindings.add(Facade.pair(this.varName, this.varType));
        Term bodyType = this.body.getType(newBindings);
        return Facade.Abs(this.varName, this.varType, bodyType);
    }

    public void setBody(Term body) {
        this.body = body;
    }

    public Term getBody() {
        return this.body;
    }

    @Override
    public void bindInFreeVars(Term typeTerm, Substitution sub) {
        this.body.bindInFreeVars(typeTerm, sub);
        this.varType.bindInFreeVars(typeTerm, sub);
    }

    @Override
    public void bindInFreeVars(Term typeTerm, Substitution sub, int i) {
        this.body.bindInFreeVars(typeTerm, sub, i);
        this.varType.bindInFreeVars(typeTerm, sub, i);
    }

    @Override
    public void bindInFreeVars(List<Term> typeTerms, Substitution sub, int idx) {
        this.body.bindInFreeVars(typeTerms, sub, idx);
        this.varType.bindInFreeVars(typeTerms, sub, idx);
    }

    @Override
    @Deprecated
    public Term oldBindInFreeVars(int i, Term typeTerm, Substitution sub) {
        Term newBody = this.body.oldBindInFreeVars(i + 1, typeTerm, sub);
        if (newBody == this.body) {
            return this;
        }
        return Abstraction.make(this.varName, this.varType, newBody);
    }

    @Override
    public Term removeBoundVarsAbove(int i) {
        Term newBody = this.body.removeBoundVarsAbove(i + 1);
        if (newBody == this.body) {
            return this;
        }
        return Abstraction.make(this.varName, this.varType, newBody);
    }

    @Override
    public void removeBoundVarsAbove(int i, Substitution sub) {
        this.body.removeBoundVarsAbove(i + 1, sub);
        this.varType.removeBoundVarsAbove(i, sub);
    }

    @Override
    public FreeVar getEtaEquivFreeVar() {
        Term t = this;
        int argCount = 0;
        while (t instanceof Abstraction) {
            t = t.body;
            ++argCount;
        }
        if (t instanceof Application) {
            Application a = (Application)t;
            if (a.getArguments().size() != argCount) {
                return null;
            }
            if (!(a.getFunction() instanceof FreeVar)) {
                return null;
            }
            int i = 0;
            while (i < argCount) {
                Term arg = a.getArguments().get(i);
                if (!(arg instanceof BoundVar)) {
                    return null;
                }
                if (((BoundVar)arg).getIndex() != argCount - i) {
                    return null;
                }
                ++i;
            }
            return (FreeVar)a.getFunction();
        }
        return null;
    }

    public Term subInside(Substitution sub, int size) {
        Term newBody;
        Term term = newBody = size > 1 ? ((Abstraction)this.body).subInside(sub, size - 1) : this.body.substitute(sub);
        if (newBody == this.body) {
            return this;
        }
        return Abstraction.make(this.varName, this.varType, newBody);
    }
}

