/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.prover;

import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.prover.Judgment;
import edu.cmu.cs.sasylf.prover.Proof;
import edu.cmu.cs.sasylf.prover.ProofImpl;
import edu.cmu.cs.sasylf.prover.Rule;
import edu.cmu.cs.sasylf.prover.RuleInstance;
import edu.cmu.cs.sasylf.prover.UnprovedNode;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import java.util.ArrayList;
import java.util.List;

public class UnprovedNodeImpl
implements UnprovedNode {
    private Judgment judgment;
    private int depth;
    private int choiceDepth;

    public UnprovedNodeImpl(Judgment j, int d, int c) {
        this.judgment = j;
        this.depth = d;
        this.choiceDepth = c;
    }

    @Override
    public int getChoiceDepth() {
        return this.choiceDepth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public List<Rule> getRulesThatApply(Proof proof) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        ProofImpl proofImpl = (ProofImpl)proof;
        Term derivTerm = this.judgment.getTerm().substitute(proofImpl.getSubstitution());
        edu.cmu.cs.sasylf.ast.Judgment judgmentType = this.judgment.getJudgmentType();
        for (edu.cmu.cs.sasylf.ast.Rule rule : judgmentType.getRules()) {
            Term ruleTerm = rule.getFreshRuleAppTerm(derivTerm, new Substitution(), null);
            List<Term> termArgs = rule.getFreeVarArgs(derivTerm);
            termArgs.add(derivTerm);
            Application appliedTerm = Facade.App((Atom)rule.getRuleAppConstant(), termArgs);
            Substitution sub = null;
            try {
                sub = appliedTerm.unify(ruleTerm);
                if (!sub.avoid(proofImpl.getInputVars())) {
                }
            }
            catch (UnificationFailed e) {}
            continue;
            ArrayList<Judgment> preconditions = new ArrayList<Judgment>();
            int i = 0;
            while (i < rule.getPremises().size()) {
                Term termArg = termArgs.get(i);
                ClauseDef clauseDef = ((ClauseUse)rule.getPremises().get(i)).getConstructor();
                edu.cmu.cs.sasylf.ast.Judgment judgeType = (edu.cmu.cs.sasylf.ast.Judgment)clauseDef.getType();
                Term substitutedTerm = termArg.substitute(sub);
                preconditions.add(new Judgment(substitutedTerm, judgeType));
                ++i;
            }
            result.add(new RuleInstance(this.judgment, preconditions, sub, rule));
        }
        return result;
    }

    @Override
    public Judgment getJudgment() {
        return this.judgment;
    }

    @Override
    public String toString(int tabs) {
        String s = "";
        int i = 0;
        while (i < tabs) {
            s = String.valueOf(s) + "\t";
            ++i;
        }
        s = String.valueOf(s) + this.judgment.toString();
        return s;
    }

    public String toString() {
        return this.judgment.toString();
    }

    @Override
    public void prettyPrint(Substitution sub) {
    }

    @Override
    public int getId() {
        return 0;
    }
}

