/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.prover;

import edu.cmu.cs.sasylf.prover.Judgment;
import edu.cmu.cs.sasylf.prover.ProofNode;
import edu.cmu.cs.sasylf.prover.ProvedNode;
import edu.cmu.cs.sasylf.prover.Rule;
import edu.cmu.cs.sasylf.prover.UnprovedNode;
import edu.cmu.cs.sasylf.term.Substitution;
import java.util.LinkedList;
import java.util.List;

public class RootNode
implements ProvedNode {
    private ProofNode child;
    private boolean unproved;
    private UnprovedNode undo;

    public RootNode(UnprovedNode node) {
        this.child = node;
        this.unproved = true;
    }

    @Override
    public void applyRule(UnprovedNode un, ProvedNode pn) {
        if (this.unproved) {
            this.child = pn;
            this.unproved = false;
            this.undo = un;
        }
    }

    @Override
    public ProvedNode undoApplyRule() {
        if (!this.unproved) {
            ProvedNode pn = (ProvedNode)this.child;
            this.child = this.undo;
            this.unproved = true;
            this.undo = null;
            return pn;
        }
        return null;
    }

    @Override
    public UnprovedNode getLeftmostUnprovedNode() {
        if (this.child instanceof UnprovedNode) {
            return (UnprovedNode)this.child;
        }
        return null;
    }

    @Override
    public List<ProofNode> getPremises() {
        LinkedList<ProofNode> result = new LinkedList<ProofNode>();
        result.add(this.child);
        return result;
    }

    @Override
    public Rule getRule() {
        if (this.unproved) {
            return null;
        }
        return ((ProvedNode)this.child).getRule();
    }

    @Override
    public List<UnprovedNode> getUnprovedNodes() {
        LinkedList<UnprovedNode> result = new LinkedList<UnprovedNode>();
        result.add((UnprovedNode)this.child);
        return result;
    }

    @Override
    public boolean hasUnprovedChildren() {
        return this.unproved;
    }

    @Override
    public Judgment getJudgment() {
        return null;
    }

    public String toString() {
        return this.child.toString();
    }

    @Override
    public String toString(int depth) {
        return this.child.toString(depth + 1);
    }

    public boolean isUnproved() {
        return this.unproved;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void prettyPrint(Substitution sub) {
        this.child.prettyPrint(sub);
    }
}

