/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.prover;

import edu.cmu.cs.sasylf.prover.Judgment;
import edu.cmu.cs.sasylf.prover.ProofNode;
import edu.cmu.cs.sasylf.prover.ProvedNode;
import edu.cmu.cs.sasylf.prover.Rule;
import edu.cmu.cs.sasylf.prover.UnprovedNode;
import edu.cmu.cs.sasylf.term.Substitution;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class ProvedNodeImpl
implements ProvedNode {
    private List<ProofNode> premises;
    private List<UnprovedNode> unproved;
    private Rule rule;
    private Judgment judgment;
    private Stack<ProvedNode> undoStates;
    private Stack<UnprovedNode> undoNodes;
    private int id = idcounter++;
    private static int idcounter = 0;

    public ProvedNodeImpl(Rule r, List<ProofNode> pre) {
        this.judgment = r.getResult();
        this.rule = r;
        this.premises = pre;
        this.undoStates = new Stack();
        this.undoNodes = new Stack();
        this.unproved = new LinkedList<UnprovedNode>();
        for (ProofNode pn : this.premises) {
            if (!(pn instanceof UnprovedNode)) continue;
            this.unproved.add((UnprovedNode)pn);
        }
    }

    @Override
    public List<ProofNode> getPremises() {
        return this.premises;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public Judgment getJudgment() {
        return this.judgment;
    }

    @Override
    public UnprovedNode getLeftmostUnprovedNode() {
        return this.unproved.get(0);
    }

    @Override
    public List<UnprovedNode> getUnprovedNodes() {
        return this.unproved;
    }

    @Override
    public boolean hasUnprovedChildren() {
        return this.unproved.size() > 0;
    }

    @Override
    public void applyRule(UnprovedNode un, ProvedNode pn) {
        this.unproved.remove(un);
        this.premises.remove(un);
        this.premises.add(pn);
        this.undoStates.push(pn);
        this.undoNodes.push(un);
    }

    @Override
    public ProvedNode undoApplyRule() {
        ProvedNode pn = this.undoStates.pop();
        UnprovedNode un = this.undoNodes.pop();
        this.premises.remove(pn);
        this.premises.add(un);
        this.unproved.add(un);
        return pn;
    }

    public String toString() {
        String s = String.valueOf(this.judgment.toString()) + "\n";
        for (ProofNode pn : this.premises) {
            s = String.valueOf(s) + pn.toString(1) + "\n";
        }
        return s;
    }

    @Override
    public String toString(int depth) {
        String s = "";
        int i = 0;
        while (i < depth) {
            s = String.valueOf(s) + "\t";
            ++i;
        }
        s = String.valueOf(s) + this.judgment.toString() + "\n";
        for (ProofNode pn : this.premises) {
            s = String.valueOf(s) + pn.toString(depth + 1) + "\n";
        }
        return s;
    }

    @Override
    public void prettyPrint(Substitution sub) {
        for (ProofNode pn : this.premises) {
            pn.prettyPrint(sub);
        }
        String s = "d" + this.getId() + ": " + this.judgment.prettyPrint(sub) + " by rule " + this.rule.prettyPrint();
        if (this.premises.size() > 0) {
            s = String.valueOf(s) + " on";
            for (ProofNode pn : this.premises) {
                s = String.valueOf(s) + " d" + pn.getId() + ",";
            }
            s = s.substring(0, s.length() - 1);
        }
        System.out.println(s);
    }

    @Override
    public int getId() {
        return idcounter - this.id;
    }
}

