/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.prover;

import edu.cmu.cs.sasylf.prover.Judgment;
import edu.cmu.cs.sasylf.prover.Proof;
import edu.cmu.cs.sasylf.prover.ProofNode;
import edu.cmu.cs.sasylf.prover.ProvedNode;
import edu.cmu.cs.sasylf.prover.ProvedNodeImpl;
import edu.cmu.cs.sasylf.prover.RootNode;
import edu.cmu.cs.sasylf.prover.Rule;
import edu.cmu.cs.sasylf.prover.UnprovedNode;
import edu.cmu.cs.sasylf.prover.UnprovedNodeImpl;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Substitution;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ProofImpl
implements Proof {
    private RootNode root;
    private List<ProvedNode> unproved;
    private Substitution substitution;
    private Set<FreeVar> inputVars = new HashSet<FreeVar>();
    private Stack<Substitution> undoSubs;
    private Stack<ProvedNode> undoStates;

    public ProofImpl(Judgment j) {
        this.unproved = new LinkedList<ProvedNode>();
        this.root = new RootNode(new UnprovedNodeImpl(j, 0, 0));
        this.unproved.add(this.root);
        this.substitution = new Substitution();
        this.undoSubs = new Stack();
        this.undoStates = new Stack();
    }

    @Override
    public void applyRule(ProvedNode pn, UnprovedNode node, Rule rule) {
        LinkedList<ProofNode> children = new LinkedList<ProofNode>();
        for (Judgment j : rule.getPreconditions()) {
            children.add(new UnprovedNodeImpl(j, node.getDepth() + 1, node.getChoiceDepth() + 1));
        }
        ProvedNodeImpl newNode = new ProvedNodeImpl(rule, children);
        if (children.size() > 0) {
            this.unproved.add(newNode);
        }
        pn.applyRule(node, newNode);
        if (!pn.hasUnprovedChildren()) {
            this.unproved.remove(pn);
        }
        this.undoStates.push(pn);
        Substitution newSubstitution = new Substitution(this.substitution);
        this.undoSubs.push(this.substitution);
        newSubstitution.compose(rule.getSubstitution());
        this.substitution = newSubstitution;
    }

    @Override
    public void undoApplyRule() {
        this.substitution = this.undoSubs.pop();
        ProvedNode pn = this.undoStates.pop();
        if (!this.unproved.contains(pn)) {
            this.unproved.add(pn);
        }
        ProvedNode un = pn.undoApplyRule();
        this.unproved.remove(un);
    }

    @Override
    public ProofNode getGoal() {
        return this.root;
    }

    @Override
    public ProvedNode getLeftmostUnprovedNodeParent() {
        return this.unproved.get(0);
    }

    @Override
    public List<ProvedNode> getUnprovedNodes() {
        return this.unproved;
    }

    @Override
    public boolean isCompleteProof() {
        return this.unproved.size() == 0;
    }

    public Substitution getSubstitution() {
        return this.substitution;
    }

    @Override
    public Set<FreeVar> getInputVars() {
        return this.inputVars;
    }

    public String toString() {
        return String.valueOf(this.root.toString()) + "\n\tsub: " + this.substitution;
    }

    @Override
    public void prettyPrint() {
        this.root.prettyPrint(this.substitution);
    }
}

