/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.prover;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import java.util.List;

public class Judgment {
    private Term term;
    private edu.cmu.cs.sasylf.ast.Judgment judgmentType;
    private Substitution sub;

    public Term getTerm() {
        return this.term;
    }

    public edu.cmu.cs.sasylf.ast.Judgment getJudgmentType() {
        return this.judgmentType;
    }

    public Judgment(Term term, edu.cmu.cs.sasylf.ast.Judgment type) {
        this.term = term;
        this.judgmentType = type;
    }

    public String toString() {
        return this.term.toString();
    }

    public int hashCode() {
        return this.term.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Judgment)) {
            return false;
        }
        Judgment j = (Judgment)obj;
        return this.term.equals(j.term);
    }

    public String prettyPrint(Substitution substitution) {
        String s = "";
        this.sub = substitution;
        List<Element> list = this.judgmentType.getForm().getElements();
        int index = 0;
        for (Element e : list) {
            s = String.valueOf(s) + this.printElement(e, (Application)this.term, index);
            if (!(e instanceof NonTerminal)) continue;
            ++index;
        }
        return s;
    }

    private String printApplication(Application app, Syntax syntax) {
        String s = "(";
        List<Clause> clauses = syntax.getClauses();
        for (Clause c : clauses) {
            ClauseDef cd = (ClauseDef)c;
            if (!app.getFunction().toString().equals(cd.getConstructorName())) continue;
            int index = 0;
            for (Element e : cd.getElements()) {
                if (e instanceof Terminal) {
                    s = String.valueOf(s) + ((Terminal)e).getSymbol();
                } else if (e instanceof NonTerminal) {
                    s = String.valueOf(s) + this.printElement(e, app, index);
                    ++index;
                }
                s = String.valueOf(s) + " ";
            }
        }
        return String.valueOf(s.trim()) + ")";
    }

    private String printElement(Element e, Application a, int index) {
        String s = "";
        if (e instanceof Terminal) {
            Terminal t = (Terminal)e;
            s = String.valueOf(s) + " " + t.getSymbol() + " ";
        } else if (e instanceof NonTerminal) {
            NonTerminal nt = (NonTerminal)e;
            List<? extends Term> args = a.getArguments();
            Term t = args.get(index);
            Syntax syntax = nt.getType();
            s = String.valueOf(s) + this.printTerm(t, syntax);
        }
        return s;
    }

    private String printTerm(Term t, Syntax syntax) {
        String s = "";
        if (t instanceof Constant) {
            Constant cn = (Constant)t;
            List<Clause> clauses = syntax.getClauses();
            for (Clause c : clauses) {
                ClauseDef cd = (ClauseDef)c;
                if (!cn.getName().equals(cd.getConstructorName())) continue;
                for (Element e : cd.getElements()) {
                    s = String.valueOf(s) + ((Terminal)e).getSymbol();
                }
            }
        } else if (t instanceof FreeVar) {
            FreeVar v = (FreeVar)t;
            Term t2 = this.sub.getSubstituted(v);
            s = t2 != null ? String.valueOf(s) + this.printTerm(t2, syntax) : String.valueOf(s) + v.getName();
        } else if (t instanceof Application) {
            s = String.valueOf(s) + this.printApplication((Application)t, syntax);
        }
        return s;
    }
}

