/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.grammar;

import edu.cmu.cs.sasylf.grammar.AcceptSymbol;
import edu.cmu.cs.sasylf.grammar.Action;
import edu.cmu.cs.sasylf.grammar.ActionType;
import edu.cmu.cs.sasylf.grammar.Conflict;
import edu.cmu.cs.sasylf.grammar.ItemRule;
import edu.cmu.cs.sasylf.grammar.ItemSet;
import edu.cmu.cs.sasylf.grammar.LRZeroParseTable;
import edu.cmu.cs.sasylf.grammar.NonTerminal;
import edu.cmu.cs.sasylf.grammar.StartSymbol;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.grammar.Terminal;
import java.util.ArrayList;
import java.util.List;

class Table {
    private List<Symbol> header;
    private Action[][] table;
    private LRZeroParseTable lrz;

    public Table(List<Symbol> ls, LRZeroParseTable transTable) {
        this.header = new ArrayList<Symbol>(ls.size());
        this.lrz = transTable;
        this.header.addAll(ls);
        this.table = new Action[this.lrz.numberOfSets()][this.header.size()];
    }

    public void addAction(int i, Symbol s, Action action) {
        Action a = this.table[i][this.header.indexOf(s)];
        if (a != null) {
            if (a instanceof Conflict) {
                Conflict c = (Conflict)a;
                c.add(action);
                return;
            }
            if (!a.equals(action)) {
                Conflict c = new Conflict(a, action);
                this.table[i][this.header.indexOf((Object)s)] = c;
            }
            return;
        }
        this.table[i][this.header.indexOf((Object)s)] = action;
    }

    public Action getAction(int index, Symbol key) {
        int keyIndex = this.header.indexOf(key);
        if (keyIndex == -1) {
            return null;
        }
        return this.table[index][keyIndex];
    }

    public void fillRow(int index, Action action) {
        int i = 0;
        while (i < this.table[index].length) {
            this.addAction(index, this.header.get(i), action);
            ++i;
        }
    }

    public static void makeGotoTable(Table t) {
        for (ItemSet state : t.lrz.getAllSets()) {
            for (ItemSet next : state.nextSets()) {
                if (!(next.getSymbol() instanceof NonTerminal)) continue;
                t.addAction(state.setNumber, next.getSymbol(), new Action(ActionType.GOTO, next.setNumber));
            }
        }
    }

    public static void makeActionTable(Table t) {
        for (ItemSet state : t.lrz.getAllSets()) {
            for (ItemRule r : state.allRules()) {
                if (!r.isReadRule()) continue;
                if (r.getLeftSide() instanceof StartSymbol) {
                    t.addAction(state.setNumber, AcceptSymbol.getAcceptSymbol(), new Action(ActionType.ACCEPT));
                    continue;
                }
                t.fillRow(state.setNumber, new Action(ActionType.REDUCE, r.getOriginalRule()));
            }
            for (ItemSet next : state.nextSets()) {
                if (!(next.getSymbol() instanceof Terminal)) continue;
                t.addAction(state.setNumber, next.getSymbol(), new Action(ActionType.SHIFT, next.setNumber));
            }
        }
    }

    public String toString() {
        String s = "State\t";
        for (Symbol s2 : this.header) {
            s = String.valueOf(s) + s2 + "\t";
        }
        s = String.valueOf(s) + "\n";
        int i = 0;
        while (i < this.table.length) {
            Action[] aa;
            s = String.valueOf(s) + i + "\t";
            Action[] actionArray = aa = this.table[i];
            int n = aa.length;
            int n2 = 0;
            while (n2 < n) {
                Action a = actionArray[n2];
                s = String.valueOf(s) + a + "\t";
                ++n2;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        return s;
    }
}

