/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.grammar;

import edu.cmu.cs.sasylf.grammar.AcceptSymbol;
import edu.cmu.cs.sasylf.grammar.Action;
import edu.cmu.cs.sasylf.grammar.DuplicateItemSetException;
import edu.cmu.cs.sasylf.grammar.Grammar;
import edu.cmu.cs.sasylf.grammar.ItemRule;
import edu.cmu.cs.sasylf.grammar.ItemSet;
import edu.cmu.cs.sasylf.grammar.LRParseTable;
import edu.cmu.cs.sasylf.grammar.NonTerminal;
import edu.cmu.cs.sasylf.grammar.StartSymbol;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.grammar.Table;
import edu.cmu.cs.sasylf.grammar.Terminal;
import java.util.LinkedList;
import java.util.List;

class LRZeroParseTable
implements LRParseTable {
    private Table actionTable;
    private Table gotoTable;
    private List<ItemSet> allSets = new LinkedList<ItemSet>();
    private int numSets = 0;

    public LRZeroParseTable(Grammar g) {
        try {
            new ItemSet(StartSymbol.getStartSymbol(), this, g.augment().allItemRules(), new LinkedList<ItemRule>());
        }
        catch (DuplicateItemSetException e) {
            e.printStackTrace();
        }
        this.actionTable = new Table(this.allTerminals(), this);
        this.gotoTable = new Table(this.allNonTerminals(), this);
        Table.makeActionTable(this.actionTable);
        Table.makeGotoTable(this.gotoTable);
    }

    @Override
    public Action nextAction(int state, Symbol s) {
        return this.actionTable.getAction(state, s);
    }

    @Override
    public Action nextGoto(int state, Symbol s) {
        return this.gotoTable.getAction(state, s);
    }

    public int getNextID() {
        return this.numSets++;
    }

    public int numberOfSets() {
        return this.numSets;
    }

    public void addFirstItemSet(ItemSet i) {
        if (this.allSets.isEmpty()) {
            this.allSets.add(i);
        }
    }

    public List<ItemSet> getAllSets() {
        return this.allSets;
    }

    public void addItemSet(ItemSet i) throws DuplicateItemSetException {
        for (ItemSet is : this.allSets) {
            if (!i.equals(is)) continue;
            throw new DuplicateItemSetException(is);
        }
        this.allSets.add(i);
    }

    public ItemSet getItemSet(int i) {
        return this.allSets.get(i);
    }

    private LinkedList<Symbol> allTerminals() {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (ItemSet is : this.allSets) {
            if (!(is.getSymbol() instanceof Terminal) || result.contains(is.getSymbol())) continue;
            result.add((Terminal)is.getSymbol());
        }
        result.add(AcceptSymbol.getAcceptSymbol());
        return result;
    }

    private LinkedList<Symbol> allNonTerminals() {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (ItemSet is : this.allSets) {
            Symbol s = is.getSymbol();
            if (!(s instanceof NonTerminal) || s instanceof StartSymbol || result.contains(s)) continue;
            result.add((NonTerminal)is.getSymbol());
        }
        return result;
    }

    public String toString() {
        String s = this.actionTable.toString();
        s = String.valueOf(s) + this.gotoTable.toString();
        return s;
    }
}

