/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.grammar;

import edu.cmu.cs.sasylf.grammar.DuplicateItemSetException;
import edu.cmu.cs.sasylf.grammar.ItemRule;
import edu.cmu.cs.sasylf.grammar.LRZeroParseTable;
import edu.cmu.cs.sasylf.grammar.Rule;
import edu.cmu.cs.sasylf.grammar.Symbol;
import java.util.LinkedList;
import java.util.List;

public class ItemSet {
    private Symbol symbol;
    private List<ItemRule> kernelRules;
    private List<ItemRule> nonKernelRules;
    private List<ItemSet> nextSets;
    private LRZeroParseTable table;
    public final int setNumber;

    public ItemSet(Symbol s, LRZeroParseTable lrz, List<ItemRule> allRules, List<ItemRule> parentRules) throws DuplicateItemSetException {
        this.symbol = s;
        this.table = lrz;
        this.nextSets = new LinkedList<ItemSet>();
        this.kernelRules = new LinkedList<ItemRule>();
        this.nonKernelRules = new LinkedList<ItemRule>();
        this.kernelRules = parentRules.isEmpty() ? ItemSet.duplicateAll(allRules, s) : ItemSet.childAll(parentRules, s);
        for (ItemSet is : this.table.getAllSets()) {
            if (!this.equals(is)) continue;
            throw new DuplicateItemSetException(is);
        }
        this.close(this.kernelRules, allRules);
        this.table.addItemSet(this);
        this.setNumber = this.table.getNextID();
        for (ItemRule r : this.kernelRules) {
            this.generateChild(r.readSymbol(), allRules, this.table);
        }
        for (ItemRule r : this.nonKernelRules) {
            this.generateChild(r.readSymbol(), allRules, this.table);
        }
    }

    private void generateChild(Symbol readSymbol, List<ItemRule> allRules, LRZeroParseTable lrz) {
        ItemSet nextSet;
        if (readSymbol == null) {
            return;
        }
        for (ItemSet s : this.nextSets) {
            if (s.symbol != readSymbol) continue;
            return;
        }
        try {
            nextSet = new ItemSet(readSymbol, this.table, allRules, this.allRules());
        }
        catch (DuplicateItemSetException e) {
            nextSet = e.originalCopy();
        }
        this.nextSets.add(nextSet);
    }

    private void close(List<ItemRule> searchRules, List<ItemRule> allRules) {
        for (ItemRule i : searchRules) {
            Symbol next = i.readSymbol();
            List<ItemRule> newRules = ItemSet.findAll(allRules, next);
            LinkedList<ItemRule> uniqueRules = new LinkedList<ItemRule>();
            for (ItemRule j : newRules) {
                boolean dupe = false;
                for (ItemRule k : this.kernelRules) {
                    if (!j.equals(k)) continue;
                    dupe = true;
                }
                for (ItemRule k : this.nonKernelRules) {
                    if (!j.equals(k)) continue;
                    dupe = true;
                }
                if (dupe) continue;
                uniqueRules.add(j);
            }
            this.nonKernelRules.addAll(uniqueRules);
            this.close(uniqueRules, allRules);
        }
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public List<ItemRule> findAll(Symbol s) {
        return ItemSet.findAll(this.allRules(), s);
    }

    public List<ItemRule> allRules() {
        LinkedList<ItemRule> result = new LinkedList<ItemRule>();
        result.addAll(this.kernelRules);
        result.addAll(this.nonKernelRules);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemSet)) {
            return false;
        }
        ItemSet o = (ItemSet)obj;
        if (!(o instanceof ItemSet)) {
            return false;
        }
        ItemSet other = o;
        if (this.kernelRules.size() != other.kernelRules.size()) {
            return false;
        }
        int i = 0;
        while (i < this.kernelRules.size()) {
            if (!this.kernelRules.get(i).equals(other.kernelRules.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.kernelRules.hashCode();
    }

    public List<ItemSet> nextSets() {
        return this.nextSets;
    }

    public static List<ItemRule> findAll(List<ItemRule> list, Symbol s) {
        LinkedList<ItemRule> result = new LinkedList<ItemRule>();
        for (ItemRule r : list) {
            if (!r.getLeftSide().equals(s)) continue;
            result.add(r);
        }
        return result;
    }

    public static List<ItemRule> duplicateAll(List<ItemRule> list, Symbol s) {
        LinkedList<ItemRule> result = new LinkedList<ItemRule>();
        for (ItemRule r : list) {
            if (!r.getLeftSide().equals(s)) continue;
            result.add(new ItemRule(r));
        }
        return result;
    }

    private static List<ItemRule> childAll(List<ItemRule> list, Symbol s) {
        LinkedList<ItemRule> result = new LinkedList<ItemRule>();
        for (ItemRule r : list) {
            if (!s.equals(r.readSymbol())) continue;
            result.add(r.childRule());
        }
        return result;
    }

    public String toString() {
        String result = "Item set " + this.setNumber + ":\n";
        for (Rule rule : this.kernelRules) {
            result = String.valueOf(result) + rule.getLeftSide() + " ->";
            for (Symbol s : rule.getRightSide()) {
                result = String.valueOf(result) + " " + s;
            }
            result = String.valueOf(result) + "\n";
        }
        for (Rule rule : this.nonKernelRules) {
            result = String.valueOf(result) + "+ " + rule.getLeftSide() + " ->";
            for (Symbol s : rule.getRightSide()) {
                result = String.valueOf(result) + " " + s;
            }
            result = String.valueOf(result) + "\n";
        }
        for (ItemSet itemSet : this.nextSets) {
            result = String.valueOf(result) + "Transition to set " + itemSet.setNumber + " on symbol " + itemSet.symbol + "\n";
        }
        return result;
    }
}

