/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.grammar;

import edu.cmu.cs.sasylf.grammar.NonTerminal;
import edu.cmu.cs.sasylf.grammar.ReadSymbol;
import edu.cmu.cs.sasylf.grammar.Rule;
import edu.cmu.cs.sasylf.grammar.Symbol;
import java.util.LinkedList;
import java.util.List;

class ItemRule
implements Rule {
    private NonTerminal left;
    private List<Symbol> right;
    private int orig;

    public ItemRule(Rule r, int index) {
        for (Symbol s : r.getRightSide()) {
            if (!(s instanceof ReadSymbol)) continue;
            throw new IllegalArgumentException("No read symbols allowed in the original rule");
        }
        this.left = r.getLeftSide();
        this.right = new LinkedList<Symbol>(r.getRightSide());
        this.right.add(0, ReadSymbol.getReadSymbol());
        this.orig = index;
    }

    private ItemRule(ItemRule r, int index) {
        this.right = new LinkedList<Symbol>();
        int i = 0;
        while (i < r.getRightSide().size()) {
            if (r.getRightSide().get(i) == ReadSymbol.getReadSymbol()) {
                this.right.add(r.getRightSide().get(i + 1));
                this.right.add(ReadSymbol.getReadSymbol());
                ++i;
            } else {
                this.right.add(r.getRightSide().get(i));
            }
            ++i;
        }
        this.left = r.left;
        this.orig = index;
    }

    public ItemRule(NonTerminal l, List<Symbol> r, int index) {
        for (Symbol s : r) {
            if (!(s instanceof ReadSymbol)) continue;
            throw new IllegalArgumentException("No read symbols allowed in the right side");
        }
        this.left = l;
        this.right = new LinkedList<Symbol>(r);
        this.right.add(0, ReadSymbol.getReadSymbol());
        this.orig = index;
    }

    ItemRule childRule() {
        if (this.getRightSide().get(this.getRightSide().size() - 1) == ReadSymbol.getReadSymbol()) {
            return null;
        }
        return new ItemRule(this, this.getOriginalRule());
    }

    public ItemRule(ItemRule r) {
        this.left = r.left;
        this.right = r.right;
        this.orig = r.orig;
    }

    @Override
    public NonTerminal getLeftSide() {
        return this.left;
    }

    @Override
    public List<Symbol> getRightSide() {
        return this.right;
    }

    public int getOriginalRule() {
        return this.orig;
    }

    public boolean isReadRule() {
        return this.right.get(this.right.size() - 1) instanceof ReadSymbol;
    }

    public String toString() {
        String r = this.left + " -> ";
        for (Symbol s : this.right) {
            r = String.valueOf(r) + s + " ";
        }
        return r;
    }

    public Symbol readSymbol() {
        if (this.right.get(this.right.size() - 1) instanceof ReadSymbol) {
            return null;
        }
        int i = 0;
        while (i < this.right.size()) {
            if (this.right.get(i) instanceof ReadSymbol) {
                return this.right.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object other) {
        ItemRule ir = (ItemRule)other;
        return this.left.equals(ir.left) && this.right.equals(ir.right);
    }
}

