/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.grammar;

import edu.cmu.cs.sasylf.grammar.AcceptSymbol;
import edu.cmu.cs.sasylf.grammar.Action;
import edu.cmu.cs.sasylf.grammar.ActionType;
import edu.cmu.cs.sasylf.grammar.AmbiguousSentenceException;
import edu.cmu.cs.sasylf.grammar.Conflict;
import edu.cmu.cs.sasylf.grammar.Grammar;
import edu.cmu.cs.sasylf.grammar.LRParseTable;
import edu.cmu.cs.sasylf.grammar.NonTerminal;
import edu.cmu.cs.sasylf.grammar.NotParseableException;
import edu.cmu.cs.sasylf.grammar.ParseNode;
import edu.cmu.cs.sasylf.grammar.Rule;
import edu.cmu.cs.sasylf.grammar.RuleNode;
import edu.cmu.cs.sasylf.grammar.Terminal;
import edu.cmu.cs.sasylf.grammar.TerminalNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

class Automaton {
    private List<Terminal> sentence;
    private LRParseTable lrz;
    private Stack<Integer> state;
    private int index;
    private LinkedList<ParseNode> buffer;
    private Grammar grammar;
    private int id;
    private static int idcounter = 0;

    public Automaton(List<? extends Terminal> list, Grammar g) throws NotParseableException {
        this.buffer = new LinkedList();
        this.state = new Stack();
        this.sentence = new LinkedList<Terminal>();
        for (Terminal terminal : list) {
            this.sentence.add(terminal);
        }
        this.sentence.add(AcceptSymbol.getAcceptSymbol());
        this.state.push(0);
        this.lrz = g.getTable();
        this.index = 0;
        this.grammar = g;
        this.id = idcounter++;
    }

    public Automaton(Automaton a) {
        this.sentence = a.sentence;
        this.lrz = a.lrz;
        this.state = this.duplicateStack(a.state);
        this.index = a.index;
        this.buffer = new LinkedList<ParseNode>(a.buffer);
        this.grammar = a.grammar;
        this.id = idcounter++;
    }

    private <T> Stack<T> duplicateStack(Stack<T> stack) {
        Stack<T> temp = new Stack<T>();
        Stack<T> clone = new Stack<T>();
        temp.addAll(stack);
        clone.addAll(temp);
        return clone;
    }

    public void parse() throws NotParseableException, AmbiguousSentenceException {
        while (!this.step()) {
        }
    }

    public boolean step() throws NotParseableException, AmbiguousSentenceException {
        Action a = this.lrz.nextAction(this.state.peek(), this.sentence.get(this.index));
        if (a == null) {
            throw new NotParseableException();
        }
        switch (a.getType()) {
            case SHIFT: {
                this.shift(a);
                break;
            }
            case REDUCE: {
                this.reduce(a);
                break;
            }
            case CONFLICT: {
                throw new AmbiguousSentenceException((Conflict)a);
            }
            case ACCEPT: {
                return true;
            }
        }
        return false;
    }

    public void act(Action a) throws NotParseableException {
        if (a.getType() == ActionType.SHIFT) {
            this.shift(a);
        } else if (a.getType() == ActionType.REDUCE) {
            this.reduce(a);
        }
    }

    private void shift(Action a) {
        this.buffer.add(new TerminalNode(this.sentence.get(this.index)));
        ++this.index;
        this.state.push(a.getNext());
    }

    private void reduce(Action a) throws NotParseableException {
        LinkedList<ParseNode> reduced = new LinkedList<ParseNode>();
        Rule r = this.grammar.getRule(a.getNext());
        int i = 0;
        while (i < r.getRightSide().size()) {
            reduced.add(0, this.buffer.removeLast());
            this.state.pop();
            ++i;
        }
        this.buffer.add(new RuleNode(r, reduced));
        Integer pk = this.state.peek();
        NonTerminal ls = r.getLeftSide();
        Action act = this.lrz.nextGoto(pk, ls);
        if (act == null) {
            throw new NotParseableException();
        }
        int st = act.getNext();
        this.state.push(st);
    }

    public RuleNode results() {
        return (RuleNode)this.buffer.get(0);
    }

    public void printBuffer() {
        System.out.print(String.valueOf(this.id) + " (" + this.state.peek() + "): ");
        for (ParseNode p : this.buffer) {
            if (p instanceof RuleNode) {
                RuleNode r = (RuleNode)p;
                System.out.print(String.valueOf(r.toStringAsNonTerminal()) + " ");
                continue;
            }
            System.out.print(p + " ");
        }
        System.out.print("\t\t");
        int i = this.index;
        while (i < this.sentence.size()) {
            System.out.print(this.sentence.get(i) + " ");
            ++i;
        }
        System.out.println();
    }

    public int getID() {
        return this.id;
    }
}

