/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast.grammar;

import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.grammar.NonTerminal;
import edu.cmu.cs.sasylf.grammar.Rule;
import edu.cmu.cs.sasylf.grammar.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GrmRule
implements Rule {
    private List<Symbol> rightSide;
    private NonTerminal leftSide;
    private ClauseDef clauseDef;

    public GrmRule(NonTerminal lhs, Symbol[] rhs, ClauseDef cd) {
        this.leftSide = lhs;
        this.rightSide = Arrays.asList(rhs);
        this.clauseDef = cd;
    }

    public GrmRule(NonTerminal lhs, List<Symbol> rhs, ClauseDef cd) {
        this.leftSide = lhs;
        this.rightSide = rhs;
        this.clauseDef = cd;
    }

    public GrmRule(NonTerminal lhs, ClauseDef cd) {
        this.leftSide = lhs;
        this.rightSide = new ArrayList<Symbol>();
        this.clauseDef = cd;
    }

    public ClauseDef getClauseDef() {
        return this.clauseDef;
    }

    public int hashCode() {
        return this.leftSide.hashCode() + this.rightSide.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GrmRule)) {
            return false;
        }
        GrmRule other = (GrmRule)o;
        return other.leftSide.equals(this.leftSide) && other.rightSide.equals(this.rightSide);
    }

    @Override
    public NonTerminal getLeftSide() {
        return this.leftSide;
    }

    @Override
    public List<Symbol> getRightSide() {
        return this.rightSide;
    }

    public String toString() {
        String r = this.leftSide + " -> ";
        for (Symbol s : this.rightSide) {
            r = String.valueOf(r) + s + " ";
        }
        return r;
    }
}

