/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.PrintContext;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.term.BoundVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.List;

public class Variable
extends Element {
    private String symbol;
    private Syntax type;

    public Variable(String s, Location l) {
        super(l);
        this.symbol = s;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Syntax getType() {
        return this.type;
    }

    @Override
    public ElemType getElemType() {
        return this.type;
    }

    @Override
    public Symbol getGrmSymbol() {
        if (this.type == null) {
            System.err.println("null type for " + this);
        }
        return this.type.getSymbol();
    }

    @Override
    public String getTerminalSymbolString() {
        return this.type.getTermSymbolString();
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable v = (Variable)obj;
        return this.symbol.equals(v.symbol);
    }

    public void setType(Syntax t) {
        if (this.type != null) {
            ErrorHandler.report("The same variable may not appear in multiple syntax definitions", (Node)this);
        }
        if (t == null) {
            ErrorHandler.report("No type can be found for variable " + this.symbol + ": did you forget to make it a case of a BNF syntax definition?", (Node)this);
        }
        this.type = t;
    }

    @Override
    public Element typecheck(Context ctx) {
        if (this.type == null) {
            String strippedName = Util.stripId(this.getSymbol());
            Variable var = ctx.varMap.get(strippedName);
            if (var != null) {
                this.setType(var.getType());
            } else {
                ErrorHandler.report("No type can be found for variable " + this.symbol + ": did you forget to make it a case of a BNF syntax definition?", (Node)this);
            }
        }
        return this;
    }

    @Override
    public void prettyPrint(PrintWriter out, PrintContext ctx) {
        out.print(this.symbol);
    }

    @Override
    public BoundVar computeTerm(List<Pair<String, Term>> varBindings) {
        int index = -1;
        int i = 0;
        while (i < varBindings.size()) {
            if (((String)varBindings.get((int)i).first).equals(this.symbol)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            ErrorHandler.report("Variable " + this.symbol + " is not bound", (Node)this);
        }
        return new BoundVar(varBindings.size() - index);
    }
}

