/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.AdaptationInfo;
import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Derivation;
import edu.cmu.cs.sasylf.ast.DerivationByAnalysis;
import edu.cmu.cs.sasylf.ast.DerivationByAssumption;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.RuleLike;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.SASyLFError;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Theorem
extends RuleLike {
    private List<Fact> foralls = new ArrayList<Fact>();
    private Clause exists;
    private List<Derivation> derivations = new ArrayList<Derivation>();
    private Theorem andTheorem;
    private boolean interfaceChecked = false;

    public Theorem(String n, Location l) {
        super(n, l);
    }

    public List<Fact> getForalls() {
        return this.foralls;
    }

    public List<Element> getPremises() {
        ArrayList<Element> l = new ArrayList<Element>();
        for (Fact f : this.foralls) {
            l.add(f.getElement());
        }
        return l;
    }

    @Override
    public Clause getConclusion() {
        return this.exists;
    }

    public Clause getExists() {
        return this.exists;
    }

    public List<Derivation> getDerivations() {
        return this.derivations;
    }

    public void setAnd(Theorem next) {
        Util.debug("setting and of " + this.getName() + " to " + next.getName());
        this.andTheorem = next;
    }

    @Override
    public Set<FreeVar> getExistentialVars() {
        Set<FreeVar> vars = this.exists.asTerm().getFreeVariables();
        for (Element e : this.getPremises()) {
            vars.removeAll(e.asTerm().getFreeVariables());
        }
        return vars;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        out.println("theorem " + this.getName() + ":");
        for (Fact forall : this.getForalls()) {
            out.print("forall ");
            forall.prettyPrint(out);
            out.print(' ');
        }
        out.print("exists ");
        this.getExists().prettyPrint(out);
        out.println(".");
        for (Derivation d : this.derivations) {
            d.prettyPrint(out);
        }
        out.println("end theorem\n");
    }

    public void checkInterface(Context ctx) {
        if (!this.interfaceChecked) {
            this.interfaceChecked = true;
            for (Fact f : this.foralls) {
                f.typecheck(ctx, false);
            }
            this.exists.typecheck(ctx);
            this.exists = (Clause)this.exists.computeClause(ctx, false);
        }
    }

    public void typecheck(Context ctx) {
        block16: {
            int oldErrorCount = ErrorHandler.getErrorCount();
            try {
                try {
                    Term theoremTerm;
                    Util.debug("checking theorem " + this.getName());
                    ctx.derivationMap = new HashMap<String, Fact>();
                    ctx.inputVars = new HashSet<FreeVar>();
                    ctx.outputVars = new HashSet<FreeVar>();
                    ctx.currentSub = new Substitution();
                    ctx.currentTheorem = this;
                    ctx.inductionVariable = null;
                    ctx.bindingTypes = new HashMap<String, List<ElemType>>();
                    ctx.adaptationMap = new HashMap<NonTerminal, AdaptationInfo>();
                    ctx.innermostGamma = null;
                    this.checkInterface(ctx);
                    for (Fact f : this.foralls) {
                        f.addToDerivationMap(ctx);
                        ctx.derivationMap.put(f.getName(), f);
                        ctx.inputVars.addAll(f.getElement().asTerm().getFreeVariables());
                        if (!(f instanceof DerivationByAssumption)) continue;
                        ClauseUse cu = (ClauseUse)f.getElement();
                        cu.asTerm();
                        if (cu.getRoot() == null) continue;
                        Util.debug("set innermostGamma to " + cu.getRoot());
                        if (ctx.innermostGamma == null) {
                            ctx.innermostGamma = cu.getRoot();
                            ctx.adaptationRoot = cu.getRoot();
                            continue;
                        }
                        if (ctx.innermostGamma.equals(cu.getRoot())) continue;
                        ErrorHandler.report(Errors.INCONSISTENT_CONTEXTS, "Theorem has inconsistent contexts " + ctx.innermostGamma + " and " + cu.getRoot(), this);
                    }
                    ctx.currentGoal = theoremTerm = this.exists.asTerm();
                    ctx.currentGoalClause = this.exists;
                    ctx.outputVars.addAll(theoremTerm.getFreeVariables());
                    ctx.outputVars.removeAll(ctx.inputVars);
                    if (this.andTheorem != null) {
                        this.andTheorem.addToMap(ctx);
                    }
                    boolean derivationErrors = false;
                    for (Derivation d : this.derivations) {
                        try {
                            d.typecheck(ctx);
                        }
                        catch (SASyLFError e) {
                            derivationErrors = true;
                        }
                    }
                    if (!derivationErrors) {
                        Theorem.verifyLastDerivation(ctx, theoremTerm, this.exists, this.derivations, this);
                    }
                    ctx.ruleMap.put(this.getName(), this);
                    ctx.recursiveTheorems = new HashMap<String, Theorem>();
                }
                catch (SASyLFError sASyLFError) {
                    int newErrorCount = ErrorHandler.getErrorCount() - oldErrorCount;
                    if (!Util.VERBOSE) break block16;
                    if (newErrorCount == 0) {
                        System.out.println("Theorem " + this.getName() + " OK");
                        break block16;
                    }
                    System.out.println("Error(s) in theorem " + this.getName());
                }
            }
            finally {
                int newErrorCount = ErrorHandler.getErrorCount() - oldErrorCount;
                if (Util.VERBOSE) {
                    if (newErrorCount == 0) {
                        System.out.println("Theorem " + this.getName() + " OK");
                    } else {
                        System.out.println("Error(s) in theorem " + this.getName());
                    }
                }
            }
        }
    }

    private void addToMap(Context ctx) {
        this.checkInterface(ctx);
        ctx.recursiveTheorems.put(this.getName(), this);
        if (this.andTheorem != null) {
            this.andTheorem.addToMap(ctx);
        }
    }

    public static void verifyLastDerivation(Context ctx, Term theoremTerm, Element theoremElem, List<Derivation> derivs, Node errorNode) {
        if (derivs.size() == 0) {
            ErrorHandler.report(Errors.NO_DERIVATION, errorNode);
        } else {
            Derivation last = derivs.get(derivs.size() - 1);
            Term derivTerm = DerivationByAnalysis.adapt(last.getElement().asTerm(), ((ClauseUse)last.getElement()).getRoot(), ctx);
            Util.debug("orig theoremTerm: " + theoremTerm);
            Util.debug("orig derivTerm: " + derivTerm);
            theoremTerm = DerivationByAnalysis.adapt(theoremTerm, ((ClauseUse)theoremElem).getRoot(), ctx);
            Util.debug("adapted theoremTerm: " + theoremTerm);
            try {
                Util.debug("end of theorem (" + last.getLocation().getLine() + "): unifying " + derivTerm + " to match " + theoremTerm);
                Util.debug("current sub = " + ctx.currentSub);
                Substitution instanceSub = derivTerm.instanceOf(theoremTerm);
                if (!instanceSub.avoid(ctx.inputVars)) {
                    Set<FreeVar> unavoidable = instanceSub.selectUnavoidable(ctx.inputVars);
                    ErrorHandler.report(Errors.WRONG_RESULT, "\n    could not avoid vars " + unavoidable, last);
                }
            }
            catch (UnificationFailed e) {
                ErrorHandler.report(Errors.WRONG_RESULT, (Node)last, "\twas checking " + derivTerm + " instance of " + theoremTerm);
            }
        }
    }

    public void setExists(Clause c) {
        this.exists = c;
    }
}

