/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Case;
import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.grammar.Grammar;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyntaxCase
extends Case {
    private Clause conclusion;

    public SyntaxCase(Location l, Clause c) {
        super(l);
        this.conclusion = c;
    }

    public Clause getConclusion() {
        return this.conclusion;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        out.print("case ");
        this.conclusion.prettyPrint(out);
        out.println(" is ");
        super.prettyPrint(out);
    }

    @Override
    public void typecheck(Context ctx, boolean isSubderivation) {
        edu.cmu.cs.sasylf.grammar.NonTerminal nt;
        Grammar g;
        Element concElem;
        Util.debug("    ******* case line " + this.getLocation().getLine());
        Map<String, List<ElemType>> oldBindingTypes = ctx.bindingTypes;
        this.conclusion.typecheck(ctx);
        if (!(ctx.currentCaseAnalysisElement instanceof NonTerminal)) {
            ErrorHandler.report(Errors.SYNTAX_CASE_FOR_DERIVATION, (Node)this);
        }
        if ((concElem = this.conclusion.computeClause(ctx, false, g = new Grammar(nt = ((NonTerminal)ctx.currentCaseAnalysisElement).getType().getSymbol(), ctx.getGrammar().getRules()))) instanceof Clause) {
            this.conclusion = (Clause)concElem;
        } else if (concElem instanceof NonTerminal) {
            ErrorHandler.report(Errors.NONTERMINAL_CASE, "Case " + this.conclusion + " is a nonterminal; it must be a decomposition of " + ctx.currentCaseAnalysisElement, this);
        } else if (concElem instanceof Variable) {
            ErrorHandler.report(Errors.UNBOUND_VAR_CASE, "Case " + this.conclusion + " is an unbound variable and so cannot stand on its own.\n\tTry case-analyzing on a judgment instead; in the variable rule case, the variable will be bound in the context.", this);
        } else {
            ErrorHandler.report("Case analysis of syntax may only be a syntax clause, not a variable, nonterminal, or binding", (Node)this);
        }
        this.conclusion.checkBindings(ctx.bindingTypes, this);
        Set<Pair<Term, Substitution>> caseResult = ctx.caseTermMap.get(((ClauseUse)this.conclusion).getConstructor());
        Util.verify(caseResult != null && caseResult.size() <= 1, "internal invariant violated");
        if (caseResult.size() == 0) {
            ErrorHandler.report(Errors.DUPLICATE_CASE, (Node)this);
        }
        Pair<Term, Substitution> pair = caseResult.iterator().next();
        Term computedCaseTerm = (Term)pair.first;
        Util.verify(caseResult.remove(pair), "internal invariant broken");
        Term concTerm = this.conclusion.asTerm();
        try {
            Util.debug("case unify " + concTerm + " and " + computedCaseTerm);
            Substitution computedSub = computedCaseTerm.instanceOf(concTerm);
        }
        catch (UnificationFailed uf) {
            ErrorHandler.report(Errors.INVALID_CASE, "Case does not apply to " + ctx.currentCaseAnalysisElement, this);
        }
        concTerm = concTerm.substitute(ctx.currentSub);
        Substitution unifyingSub = null;
        try {
            unifyingSub = concTerm.unify(ctx.currentCaseAnalysis);
        }
        catch (UnificationFailed uf) {
            ErrorHandler.report(Errors.INVALID_CASE, "Case " + this.conclusion + " is not actually a case of " + ctx.currentCaseAnalysisElement, this);
        }
        Substitution oldSub = new Substitution(ctx.currentSub);
        ctx.currentSub.compose(unifyingSub);
        Set<FreeVar> oldInputVars = ctx.inputVars;
        ctx.inputVars = new HashSet<FreeVar>(oldInputVars);
        ctx.inputVars.addAll(concTerm.getFreeVariables());
        Util.debug("current case analysis: " + ctx.currentCaseAnalysis);
        if (ctx.currentCaseAnalysis instanceof FreeVar) {
            ctx.inputVars.remove((FreeVar)ctx.currentCaseAnalysis);
        }
        ArrayList<Fact> oldSubderivations = new ArrayList<Fact>(ctx.subderivations);
        if (isSubderivation) {
            ctx.subderivations.addAll(((ClauseUse)this.conclusion).getNonTerminals());
        }
        super.typecheck(ctx, isSubderivation);
        ctx.currentSub = oldSub;
        ctx.inputVars = oldInputVars;
        ctx.subderivations = oldSubderivations;
        ctx.bindingTypes = oldBindingTypes;
    }
}

