/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import java.io.PrintWriter;

public class SyntaxAssumption
extends Fact {
    private NonTerminal nonTerminal;
    private boolean isTheoremArg = false;

    public SyntaxAssumption(String n, Location l, boolean isTheoremArg) {
        this(new NonTerminal(n, l));
        this.isTheoremArg = isTheoremArg;
    }

    public SyntaxAssumption(String n, Location l) {
        this(new NonTerminal(n, l));
    }

    public SyntaxAssumption(NonTerminal nt) {
        super(nt.getSymbol(), nt.getLocation());
        this.nonTerminal = nt;
    }

    public Syntax getSyntax() {
        return this.nonTerminal.getType();
    }

    @Override
    public Element getElement() {
        return this.nonTerminal;
    }

    public boolean isTheoremArg() {
        return this.isTheoremArg;
    }

    public int hashCode() {
        return this.nonTerminal.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SyntaxAssumption)) {
            return false;
        }
        SyntaxAssumption sa = (SyntaxAssumption)obj;
        return this.nonTerminal.equals(sa.nonTerminal);
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        out.print(this.getName());
    }

    @Override
    public void typecheck(Context ctx, boolean addToMap) {
        Element e = this.nonTerminal.typecheck(ctx);
        if (e != this.nonTerminal) {
            ErrorHandler.report("No syntax match for " + this.getName(), (Node)this);
        }
        if (addToMap) {
            this.addToDerivationMap(ctx);
        }
    }
}

