/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseType;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.ast.grammar.GrmNonTerminal;
import edu.cmu.cs.sasylf.ast.grammar.GrmRule;
import edu.cmu.cs.sasylf.ast.grammar.GrmTerminal;
import edu.cmu.cs.sasylf.ast.grammar.GrmUtil;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Syntax
extends Node
implements ClauseType,
ElemType {
    private List<Clause> elements;
    private NonTerminal nonTerminal;
    private Constant term = null;
    private GrmNonTerminal gnt;
    private GrmTerminal gt;

    public Syntax(NonTerminal nt, List<Clause> l) {
        this.nonTerminal = nt;
        this.elements = l;
    }

    public NonTerminal getNonTerminal() {
        return this.nonTerminal;
    }

    public List<Clause> getClauses() {
        return this.elements;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        this.nonTerminal.prettyPrint(out);
        out.print("\t::= ");
        boolean prev = false;
        for (Clause c : this.getClauses()) {
            if (prev) {
                out.print("\t|   ");
            }
            c.prettyPrint(out);
            prev = true;
            out.println();
        }
        out.println("\n");
    }

    public Set<Terminal> getTerminals() {
        HashSet<Terminal> s = new HashSet<Terminal>();
        for (Clause c : this.getClauses()) {
            s.addAll(c.getTerminals());
        }
        return s;
    }

    public void getVariables(Map<String, Variable> map) {
        for (Clause c : this.getClauses()) {
            if (c == null) {
                System.err.println("null clause in Syntax " + this);
            }
            c.getVariables(map);
        }
    }

    public void typecheck(Context ctx) {
        ClauseDef cd;
        Clause c;
        int i = 0;
        while (i < this.elements.size()) {
            c = this.elements.get(i);
            c.typecheck(ctx);
            if (!c.isVarOnlyClause()) {
                cd = new ClauseDef(c, this);
                this.elements.set(i, cd);
                ctx.parseMap.put(cd.getElemTypes(), cd);
                GrmRule r = new GrmRule(this.getSymbol(), cd.getSymbols(), cd);
                ctx.ruleSet.add(r);
                if (r.getRightSide().size() > 1 || r.getRightSide().get(0) instanceof GrmTerminal) {
                    GrmRule rParens = new GrmRule(this.getSymbol(), new ArrayList<Symbol>(r.getRightSide()), cd);
                    rParens.getRightSide().add(0, GrmUtil.terminalFor("("));
                    rParens.getRightSide().add(GrmUtil.terminalFor(")"));
                    ctx.ruleSet.add(rParens);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.elements.size()) {
            c = this.elements.get(i);
            if (!c.isVarOnlyClause()) {
                cd = (ClauseDef)c;
                cd.checkVarUse(this.isInContextForm());
            }
            ++i;
        }
        GrmRule termRule = new GrmRule(this.getSymbol(), new GrmTerminal[]{this.getTermSymbol()}, null);
        ctx.ruleSet.add(termRule);
        termRule = new GrmRule(this.getSymbol(), new GrmTerminal[]{GrmUtil.terminalFor("("), this.getTermSymbol(), GrmUtil.terminalFor(")")}, null);
        ctx.ruleSet.add(termRule);
        GrmRule startRule = new GrmRule(GrmUtil.getStartSymbol(), new Symbol[]{this.getSymbol()}, null);
        ctx.ruleSet.add(startRule);
    }

    public boolean isInContextForm() {
        boolean isContext;
        int terminalCaseCount = 0;
        int contextCaseCount = 0;
        for (Clause c : this.getClauses()) {
            if (this.isTerminalCase(c)) {
                ++terminalCaseCount;
                continue;
            }
            if (!this.isContextCase(c)) continue;
            ++contextCaseCount;
        }
        boolean bl = isContext = terminalCaseCount == 1 && contextCaseCount == this.getClauses().size() - 1;
        if (isContext) {
            Util.debug("Found a context: " + this.getNonTerminal());
        }
        return isContext;
    }

    private boolean isContextCase(Clause c) {
        boolean found = false;
        for (ElemType eType : c.getElemTypes()) {
            if (eType == this) {
                found = true;
                continue;
            }
            if (eType instanceof Syntax) {
                Util.debug("Not it: " + ((Syntax)eType).getNonTerminal());
                continue;
            }
            Util.debug("Not it: " + eType);
        }
        if (!found) {
            Util.debug("Not found: " + c);
            return false;
        }
        for (Element e : c.getElements()) {
            if (e instanceof Variable) {
                Util.debug("Found a context case: " + c);
                return true;
            }
            Util.debug("Not a variable: " + e);
        }
        return false;
    }

    private boolean isTerminalCase(Clause c) {
        for (Element e : c.getElements()) {
            if (e instanceof Terminal) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.nonTerminal.toString();
    }

    public void computeVarTypes(Map<String, Variable> varMap) {
        for (Clause c : this.getClauses()) {
            c.computeVarTypes(this, varMap);
        }
    }

    @Override
    public Constant typeTerm() {
        if (this.term == null) {
            this.term = new Constant(this.nonTerminal.getSymbol(), Constant.TYPE);
        }
        return this.term;
    }

    public edu.cmu.cs.sasylf.grammar.NonTerminal getSymbol() {
        if (this.gnt == null) {
            this.gnt = new GrmNonTerminal(this.nonTerminal.getSymbol());
        }
        return this.gnt;
    }

    public String getTermSymbolString() {
        return "__TERM_FOR_" + this.nonTerminal.getSymbol();
    }

    public GrmTerminal getTermSymbol() {
        if (this.gt == null) {
            this.gt = new GrmTerminal("__TERM_FOR_" + this.nonTerminal.getSymbol(), this.nonTerminal);
        }
        return this.gt;
    }
}

