/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class RuleLike
extends Node {
    private String name;
    private Constant ruleAppConstant;

    public RuleLike(String n, Location l) {
        super(l);
        this.name = n;
    }

    public RuleLike(String n) {
        this.name = n;
    }

    public abstract List<? extends Element> getPremises();

    public abstract Set<FreeVar> getExistentialVars();

    public abstract Clause getConclusion();

    public String getName() {
        return this.name;
    }

    public Constant getRuleAppConstant() {
        if (this.ruleAppConstant == null) {
            Term typeTerm = Facade.Const(String.valueOf(this.getName()) + "BASE", Constant.TYPE);
            ArrayList<Term> argTypes = new ArrayList<Term>();
            int i = 0;
            while (i < this.getPremises().size()) {
                argTypes.add(this.getPremises().get(i).getTypeTerm());
                ++i;
            }
            argTypes.add(((ClauseUse)this.getConclusion()).getConstructor().asTerm());
            typeTerm = Term.wrapWithLambdas(typeTerm, argTypes);
            this.ruleAppConstant = Facade.Const(String.valueOf(this.name) + "TERM", typeTerm);
        }
        return this.ruleAppConstant;
    }

    public List<Term> getFreeVarArgs(Term instanceTerm) {
        Term concTerm = this.getConclusion().asTerm();
        int adaptation = 0;
        Util.debug("adaptation: " + adaptation);
        ArrayList<Term> termArgs = new ArrayList<Term>();
        int i = 0;
        while (i < this.getPremises().size()) {
            ClauseUse clauseUse = (ClauseUse)this.getPremises().get(i);
            ClauseDef clauseDef = clauseUse.getConstructor();
            Term type = Constant.UNKNOWN_TYPE;
            String name = clauseDef.getConstructorName();
            Term argTerm = Facade.FreshVar(name, type);
            Util.debug("before: " + argTerm);
            argTerm = clauseUse.wrapWithOuterLambdas(argTerm, instanceTerm, adaptation);
            Util.debug("after: " + argTerm);
            termArgs.add(argTerm);
            ++i;
        }
        return termArgs;
    }

    public Term getFreshRuleAppTerm(Term instanceTerm, Substitution wrappingSub, List<Term> termArgsIfKnown) {
        Util.debug("getting conclusion term for rule " + this.getName());
        Term concTerm = this.getConclusion().asTerm();
        Substitution ruleSub = new Substitution();
        ruleSub = concTerm.freshSubstitution(ruleSub);
        concTerm = concTerm.substitute(ruleSub);
        int adaptation = ((ClauseUse)this.getConclusion()).getAdaptationNumber(concTerm, instanceTerm, false);
        ArrayList<Term> args = new ArrayList<Term>();
        int i = 0;
        while (i < this.getPremises().size()) {
            Element elem = this.getPremises().get(i);
            Term argTerm = elem.asTerm();
            ruleSub = argTerm.freshSubstitution(ruleSub);
            argTerm = argTerm.substitute(ruleSub);
            if (elem instanceof ClauseUse) {
                ClauseUse clause = (ClauseUse)elem;
                Util.debug("\tgenerated argterm before adaptation: " + argTerm);
                if (clause.isRootedInVar()) {
                    int localAdaptation = adaptation;
                    Term localInstanceTerm = instanceTerm;
                    if (termArgsIfKnown != null && !((ClauseUse)this.getConclusion()).isRootedInVar()) {
                        localInstanceTerm = termArgsIfKnown.get(i);
                        localAdaptation = clause.getAdaptationNumber(argTerm, localInstanceTerm, false);
                    }
                    Util.debug("adaptation of " + argTerm + " to " + localInstanceTerm + " is " + localAdaptation);
                    argTerm = clause.wrapWithOuterLambdas(argTerm, localInstanceTerm, localAdaptation, wrappingSub, false);
                    Util.debug("\tresult is " + argTerm);
                }
            }
            args.add(argTerm);
            ++i;
        }
        Util.debug("\tgenerated concterm before adaptation: " + concTerm);
        Util.debug("adaptation of " + concTerm + " to " + instanceTerm + " is " + adaptation);
        concTerm = ((ClauseUse)this.getConclusion()).wrapWithOuterLambdas(concTerm, instanceTerm, adaptation, wrappingSub, false);
        Util.debug("\tresult is " + concTerm);
        args.add(concTerm);
        Application ruleTerm = Facade.App((Atom)this.getRuleAppConstant(), args);
        return ruleTerm;
    }
}

