/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.AdaptationInfo;
import edu.cmu.cs.sasylf.ast.Case;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Derivation;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Rule;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.EOCUnificationFailed;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.SASyLFError;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleCase
extends Case {
    private Derivation conclusion;
    private List<Derivation> premises;
    private String ruleName;
    private Rule rule;

    public RuleCase(Location l, String rn, List<Derivation> ps, Derivation c) {
        super(l);
        this.conclusion = c;
        this.premises = ps;
        this.ruleName = rn;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Rule getRule() {
        return this.rule;
    }

    public List<Derivation> getPremises() {
        return this.premises;
    }

    public Derivation getConclusion() {
        return this.conclusion;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        out.println("case rule\n");
        for (Derivation d : this.premises) {
            out.print("premise ");
            d.prettyPrint(out);
            out.println();
        }
        out.print("--------------------- ");
        out.println(this.ruleName);
        this.conclusion.prettyPrint(out);
        out.println("\n\nis\n");
        super.prettyPrint(out);
    }

    @Override
    public void typecheck(Context ctx, boolean isSubderivation) {
        Set<Pair<Term, Substitution>> caseResult;
        Util.debug("line " + this.getLocation().getLine() + " case " + this.ruleName);
        Util.debug("    currentSub = " + ctx.currentSub);
        this.rule = (Rule)ctx.ruleMap.get(this.ruleName);
        if (this.rule == null) {
            ErrorHandler.report(Errors.RULE_NOT_FOUND, this.ruleName, this);
        }
        if (this.rule.getPremises().size() != this.getPremises().size()) {
            ErrorHandler.report(Errors.RULE_PREMISE_NUMBER, this.getRuleName(), this);
        }
        Map<String, List<ElemType>> oldBindingTypes = ctx.bindingTypes;
        ctx.bindingTypes = new HashMap<String, List<ElemType>>(ctx.bindingTypes);
        for (Derivation d : this.premises) {
            d.typecheck(ctx);
            d.getClause().checkBindings(ctx.bindingTypes, this);
        }
        this.conclusion.typecheck(ctx);
        this.conclusion.getClause().checkBindings(ctx.bindingTypes, this);
        if (ctx.currentCaseAnalysisElement instanceof NonTerminal) {
            ErrorHandler.report("When case-analyzing a non-terminal, must use syntax cases, not rule cases", (Node)this);
        }
        if ((caseResult = ctx.caseTermMap.get(this.rule)) == null) {
            ErrorHandler.report(Errors.EXTRA_CASE, ": rule " + this.ruleName + " cannot be used to derive " + ctx.currentCaseAnalysisElement, this);
        }
        if (caseResult.isEmpty()) {
            ErrorHandler.report(Errors.EXTRA_CASE, (Node)this);
        }
        Term concTerm = this.conclusion.getElement().asTerm();
        concTerm = concTerm.substitute(ctx.currentSub);
        Substitution adaptationSub = new Substitution();
        Term adaptedCaseAnalysis = ctx.currentCaseAnalysisElement.adaptTermTo(ctx.currentCaseAnalysis, concTerm, adaptationSub);
        Util.debug("adapation: " + adaptationSub + "\n\tapplied to " + ctx.currentCaseAnalysis + "\n\tis " + ctx.currentCaseAnalysis.substitute(adaptationSub));
        int lambdaDifference = adaptedCaseAnalysis.countLambdas() - ctx.currentCaseAnalysis.countLambdas();
        Substitution oldAdaptationSub = ctx.adaptationSub;
        HashMap<NonTerminal, AdaptationInfo> oldAdaptationMap = new HashMap<NonTerminal, AdaptationInfo>(ctx.adaptationMap);
        NonTerminal oldInnermostGamma = ctx.innermostGamma;
        Term oldMatchTerm = ctx.matchTermForAdaptation;
        try {
            Set<FreeVar> unavoidable;
            if (lambdaDifference > 0) {
                if (ctx.adaptationSub != null) {
                    if (ctx.matchTermForAdaptation.countLambdas() == adaptedCaseAnalysis.countLambdas()) {
                        adaptationSub = new Substitution(ctx.adaptationSub);
                        adaptedCaseAnalysis = ctx.currentCaseAnalysisElement.adaptTermTo(ctx.currentCaseAnalysis, concTerm, adaptationSub);
                    } else {
                        ErrorHandler.report("Sorry, more than one nested variable rule case analysis is not yet supported", (Node)this);
                    }
                }
                ctx.adaptationSub = new Substitution(adaptationSub);
                adaptationSub.incrFreeDeBruijn(-lambdaDifference);
                ctx.matchTermForAdaptation = adaptedCaseAnalysis;
                AdaptationInfo info = new AdaptationInfo(((ClauseUse)this.conclusion.getClause()).getRoot());
                ClauseUse.readNamesAndTypes((Abstraction)adaptedCaseAnalysis, lambdaDifference, info.varNames, info.varTypes);
                if (ctx.innermostGamma.equals(info.nextContext)) {
                    ErrorHandler.report(Errors.REUSED_CONTEXT, "May not re-use context name " + ctx.innermostGamma, this);
                }
                if (ctx.adaptationMap.containsKey(ctx.innermostGamma)) {
                    ErrorHandler.report(Errors.REUSED_CONTEXT, "May not re-use context name " + ctx.innermostGamma, this);
                }
                ctx.adaptationMap.put(ctx.innermostGamma, info);
                ctx.innermostGamma = info.nextContext;
                Util.verify(info.nextContext != null, "internal invariant violated");
            }
            Term adaptedConcTerm = concTerm.substitute(adaptationSub);
            Util.debug("concTerm: " + concTerm);
            Substitution unifyingSub = null;
            try {
                Util.debug("case unify " + adaptedConcTerm + " with " + adaptedCaseAnalysis);
                unifyingSub = adaptedConcTerm.unify(adaptedCaseAnalysis);
            }
            catch (EOCUnificationFailed uf) {
                ErrorHandler.report(Errors.INVALID_CASE, "Case " + this.conclusion.getElement() + " is not actually a case of " + ctx.currentCaseAnalysisElement + "\n    Did you re-use a variable (perhaps " + uf.eocTerm + ") which was already in scope?  If so, try using some other variable name in this case.", this);
            }
            catch (UnificationFailed uf) {
                Util.debug(this.getLocation() + ": was unifying " + adaptedConcTerm + " and " + adaptedCaseAnalysis);
                ErrorHandler.report(Errors.INVALID_CASE, "Case " + this.conclusion.getElement() + " is not actually a case of " + ctx.currentCaseAnalysisElement, this, "SASyLF computed the LF term " + adaptedCaseAnalysis + " for the conclusion");
            }
            catch (SASyLFError error) {
                throw error;
            }
            catch (RuntimeException rt) {
                System.err.println(this.getLocation() + ": was unifying " + adaptedConcTerm + " and " + adaptedCaseAnalysis);
                throw rt;
            }
            Term caseTerm = this.computeTerm(ctx);
            Term computedCaseTerm = null;
            Term candidate = null;
            Substitution pairSub = null;
            HashSet<FreeVar> newInputVars = new HashSet<FreeVar>(ctx.inputVars);
            for (Pair<Term, Substitution> pair : caseResult) {
                try {
                    pairSub = new Substitution((Substitution)pair.second);
                    Util.debug("\tpair.second was " + pairSub);
                    pairSub.selectUnavoidable(ctx.inputVars);
                    candidate = ((Term)pair.first).substitute(pairSub);
                    Util.debug("\tunifying sub = " + unifyingSub);
                    caseTerm = caseTerm.substitute(unifyingSub);
                    Util.debug("case analysis: does " + caseTerm + " generalize " + candidate);
                    Util.debug("\tpair.second is now " + pairSub);
                    Substitution computedSub = candidate.instanceOf(caseTerm);
                    computedCaseTerm = candidate;
                    Util.debug("\told input vars = " + newInputVars);
                    Util.debug("\tcomputed sub = " + computedSub);
                    Set<FreeVar> unavoidableInputVars = pairSub.selectUnavoidable(newInputVars);
                    if (!unavoidableInputVars.isEmpty()) {
                        Util.debug("\tremoving input vars " + unavoidableInputVars);
                    }
                    newInputVars.removeAll(unavoidableInputVars);
                    HashSet<Atom> computedSubDomain = new HashSet<Atom>(computedSub.getMap().keySet());
                    computedSubDomain.retainAll(newInputVars);
                    if (!computedSubDomain.isEmpty()) {
                        ErrorHandler.report(Errors.INVALID_CASE, "Case " + this.conclusion.getElement() + " is not actually a case of " + ctx.currentCaseAnalysisElement + "\n    The term given requires instantiating the following variable(s) that should be free: " + computedSubDomain, this);
                    }
                    Util.verify(caseResult.remove(pair), "internal invariant broken");
                    break;
                }
                catch (UnificationFailed computedSub) {
                    // empty catch block
                }
            }
            if (computedCaseTerm == null) {
                String errorDescription = this.rule.getErrorDescription(candidate, ctx);
                Util.debug("Expected case:\n" + errorDescription);
                Util.debug("Your case roundtripped:\n" + this.rule.getErrorDescription(caseTerm, ctx));
                Util.debug("SASyLF generated the LF term: " + candidate);
                Util.debug("You proposed the LF term: " + caseTerm);
                ErrorHandler.report(Errors.INVALID_CASE, "The rule case given is invalid; it is most likely too specific in some way and should be generalized", this, "SASyLF considered the LF term " + candidate);
            }
            if (!(unavoidable = unifyingSub.selectUnavoidable(newInputVars)).isEmpty()) {
                ErrorHandler.report(Errors.INVALID_CASE, "Case " + this.conclusion.getElement() + " is not actually a case of " + ctx.currentCaseAnalysisElement + "\n    The term given requires instantiating the following variable(s) that should be free: " + unavoidable, this);
            }
            Util.debug("unifyingSub: " + unifyingSub);
            Util.debug("pairSub: " + pairSub);
            for (Atom pairSubKey : pairSub.getMap().keySet()) {
                if (!unifyingSub.getMap().containsKey(pairSubKey)) continue;
                Term ec = pairSub.getSubstituted(pairSubKey);
                Term em = unifyingSub.getSubstituted(pairSubKey);
                Substitution subOfSubs = null;
                try {
                    Util.debug("trying " + pairSubKey + ": " + ec + " instanceof " + em);
                    subOfSubs = ec.instanceOf(em);
                    Util.debug("subOfSubs: " + subOfSubs + " for " + pairSubKey);
                }
                catch (Exception e) {
                    ErrorHandler.report(Errors.INVALID_CASE, "The rule case given is invalid, perhaps due to introducing a fresh variable in the wrong order into a term", this, "SASyLF considered the LF term " + candidate);
                }
                for (Atom subOfSubsKey : subOfSubs.getMap().keySet()) {
                    if (!ctx.inputVars.contains(subOfSubsKey)) continue;
                    ErrorHandler.report(Errors.INVALID_CASE, "When substituting for input variable " + pairSubKey + ", case makes invalid assumptions about the structure of " + subOfSubsKey, this);
                }
            }
            Substitution oldSub = new Substitution(ctx.currentSub);
            Util.debug("composing " + ctx.currentSub + " with " + unifyingSub);
            Util.debug("old sub: " + oldSub);
            ctx.currentSub.compose(unifyingSub);
            Util.debug("result: " + ctx.currentSub);
            Set<FreeVar> oldInputVars = ctx.inputVars;
            ctx.inputVars = newInputVars;
            Set<FreeVar> addedInputVars = adaptedConcTerm.getFreeVariables();
            for (Derivation d : this.premises) {
                Term premiseTerm = d.getElement().asTerm();
                premiseTerm = premiseTerm.substitute(ctx.currentSub);
                addedInputVars.addAll(premiseTerm.getFreeVariables());
            }
            addedInputVars.removeAll(newInputVars);
            if (!addedInputVars.isEmpty()) {
                Util.debug("\tadding new input vars " + addedInputVars);
            }
            ctx.inputVars.addAll(addedInputVars);
            ArrayList<Fact> oldSubderivations = new ArrayList<Fact>(ctx.subderivations);
            if (isSubderivation) {
                ctx.subderivations.addAll(this.premises);
            }
            try {
                super.typecheck(ctx, isSubderivation);
            }
            finally {
                ctx.currentSub = oldSub;
                ctx.inputVars = oldInputVars;
                ctx.subderivations = oldSubderivations;
            }
        }
        finally {
            ctx.adaptationSub = oldAdaptationSub;
            ctx.adaptationMap = oldAdaptationMap;
            ctx.innermostGamma = oldInnermostGamma;
            ctx.bindingTypes = oldBindingTypes;
            ctx.matchTermForAdaptation = oldMatchTerm;
        }
    }

    private Term computeTerm(Context ctx) {
        Term concTerm = this.conclusion.getElement().asTerm();
        Util.debug("concTerm = " + concTerm + " currentSub = " + ctx.currentSub);
        ArrayList<Term> args = new ArrayList<Term>();
        int i = 0;
        while (i < this.getPremises().size()) {
            Term argTerm = this.getPremises().get(i).getElement().asTerm();
            args.add(argTerm);
            ++i;
        }
        args.add(concTerm);
        Term ruleTerm = Facade.App((Atom)this.getRule().getRuleAppConstant(), args);
        Util.debug("ruleTerm = " + ruleTerm + " currentSub = " + ctx.currentSub);
        ruleTerm = ruleTerm.substitute(ctx.currentSub);
        Util.debug("new term = " + ruleTerm);
        return ruleTerm;
    }
}

