/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.CanBeCase;
import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Judgment;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.RuleLike;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Rule
extends RuleLike
implements CanBeCase {
    private List<Clause> premises;
    private Clause conclusion;
    private boolean isAssumpt = false;

    public Rule(Location loc, String n, List<Clause> l, Clause c) {
        super(n, loc);
        this.premises = l;
        this.conclusion = c;
    }

    public List<Clause> getPremises() {
        return this.premises;
    }

    @Override
    public Clause getConclusion() {
        return this.conclusion;
    }

    @Override
    public Set<FreeVar> getExistentialVars() {
        return new HashSet<FreeVar>();
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        for (Clause c : this.premises) {
            out.print("premise ");
            c.prettyPrint(out);
            out.println();
        }
        out.print("--------------------- ");
        out.println(this.getName());
        this.conclusion.prettyPrint(out);
        out.println("\n");
    }

    public void typecheck(Context ctx, Judgment judge) {
        HashMap<String, List<ElemType>> bindingTypes = new HashMap<String, List<ElemType>>();
        this.conclusion.typecheck(ctx);
        ClauseUse myConc = (ClauseUse)this.conclusion.computeClause(ctx, false);
        if (!(myConc.getConstructor().getType() instanceof Judgment)) {
            ErrorHandler.report(Errors.JUDGMENT_EXPECTED, "Rule conclusion must be a judgment form, not just syntax", myConc);
        }
        if (myConc.getConstructor().getType() != judge) {
            ErrorHandler.report(Errors.WRONG_JUDGMENT, "Rule conclusion was expected to be a " + judge.getName() + " judgment but instead had the form of the " + ((Judgment)myConc.getConstructor().getType()).getName() + " judgment", myConc);
        }
        myConc.checkBindings(bindingTypes, this);
        this.conclusion = myConc;
        int i = 0;
        while (i < this.premises.size()) {
            Clause c = this.premises.get(i);
            c.typecheck(ctx);
            ClauseUse premiseClause = (ClauseUse)c.computeClause(ctx, false);
            if (!(premiseClause.getConstructor().getType() instanceof Judgment)) {
                ErrorHandler.report(Errors.JUDGMENT_EXPECTED, "Rule premise must be a judgment form, not just syntax", premiseClause);
            }
            premiseClause.checkBindings(bindingTypes, this);
            this.premises.set(i, premiseClause);
            ++i;
        }
        ctx.ruleMap.put(this.getName(), this);
        this.computeAssumption(ctx);
    }

    private void computeAssumption(Context ctx) {
        ClauseUse concClauseUse = (ClauseUse)this.getConclusion();
        Judgment parent = (Judgment)concClauseUse.getConstructor().getType();
        if (this.premises.size() > 0 || parent.getAssume() == null) {
            return;
        }
        int assumeIndex = ((ClauseDef)parent.getForm()).getAssumeIndex();
        Element assumeElement = this.getConclusion().getElements().get(assumeIndex);
        if (!(assumeElement instanceof Clause)) {
            return;
        }
        ClauseUse assumeClause = (ClauseUse)assumeElement;
        Syntax gammaType = (Syntax)assumeClause.getConstructor().getType();
        boolean found = false;
        for (ElemType eType : assumeClause.getElemTypes()) {
            if (eType != gammaType) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        Element varElem = null;
        for (Element e : assumeClause.getElements()) {
            if (!(e instanceof Variable)) continue;
            varElem = e;
        }
        if (varElem == null) {
            return;
        }
        boolean foundVar = false;
        for (Element e : this.getConclusion().getElements()) {
            if (!e.equals(varElem)) continue;
            foundVar = true;
        }
        if (foundVar) {
            this.isAssumpt = true;
            if (assumeClause.getConstructor().assumptionRule != null) {
                ErrorHandler.report("Multiple uses of the same assumption not supported", (Node)this);
            }
            assumeClause.getConstructor().assumptionRule = this;
            int numBodyNonTerminals = 0;
            int numAssumptionNonTerminals = 0;
            for (Element e : assumeClause.getElements()) {
                if (!(e instanceof NonTerminal)) continue;
                ++numAssumptionNonTerminals;
            }
            for (Element e : this.getConclusion().getElements()) {
                if (!(e instanceof NonTerminal)) continue;
                ++numBodyNonTerminals;
            }
            if (numBodyNonTerminals > numAssumptionNonTerminals) {
                ErrorHandler.report("In a variable rule, no nonterminal should be mentioned in the main part of the rule unless it is mentioned in the context assumption", (Node)this);
            }
        }
    }

    public boolean isAssumption() {
        return this.isAssumpt;
    }

    public Set<Pair<Term, Substitution>> caseAnalyze(Context ctx) {
        Term term = ctx.currentCaseAnalysis;
        ClauseUse clause = (ClauseUse)ctx.currentCaseAnalysisElement;
        HashSet<Pair<Term, Substitution>> result = new HashSet<Pair<Term, Substitution>>();
        Term ruleTerm = this.getFreshRuleAppTerm(term, new Substitution(), null);
        Util.debug("\tfor rule " + this.getName() + " computed rule term " + ruleTerm);
        List<Term> termArgs = this.getFreeVarArgs(term);
        termArgs.add(term);
        Application appliedTerm = Facade.App((Atom)this.getRuleAppConstant(), termArgs);
        Pair<Term, Substitution> pair = this.checkRuleApplication(term, ruleTerm, appliedTerm);
        if (pair != null) {
            Util.debug("\tadding " + pair.first);
            result.add(pair);
        }
        if (this.isAssumption()) {
            int assumptionDepth = term.countLambdas();
            if (assumptionDepth > 0) {
                if (assumptionDepth > 2) {
                    ErrorHandler.report("Sorry, haven't yet implemented case analysis when there is more than one variable in scope", (Node)this);
                }
                Util.debug("applied term is " + appliedTerm);
                Abstraction ruleConcTerm = (Abstraction)((Application)ruleTerm).getArguments().get(0);
                Abstraction ruleConcTermInner = (Abstraction)ruleConcTerm.getBody();
                Term ruleConcBodyTerm = ruleConcTermInner.getBody();
                Term ruleTerm2 = ruleConcBodyTerm.incrFreeDeBruijn(2);
                Abstraction termAsAbstraction = (Abstraction)term;
                Abstraction termAsAbstraction2 = (Abstraction)termAsAbstraction.getBody();
                ruleTerm2 = Facade.Abs(termAsAbstraction2.varName, termAsAbstraction2.varType, ruleTerm2);
                ruleTerm2 = Facade.Abs(termAsAbstraction.varName, termAsAbstraction.varType, ruleTerm2);
                ruleTerm2 = Facade.Abs(ruleConcTermInner.varName, ruleConcTermInner.varType, ruleTerm2);
                ruleTerm2 = Facade.Abs(ruleConcTerm.varName, ruleConcTerm.varType, ruleTerm2);
                ruleTerm2 = Facade.App(((Application)ruleTerm).getFunction(), ruleTerm2);
                Substitution sub = new Substitution();
                term.bindInFreeVars(ruleConcTerm.varType, sub);
                Term appliedTerm2 = term.substitute(sub);
                appliedTerm2 = appliedTerm2.incrFreeDeBruijn(1);
                appliedTerm2 = Facade.Abs(ruleConcTermInner.varName, ruleConcTermInner.varType, appliedTerm2);
                appliedTerm2 = Facade.Abs(ruleConcTerm.varName, ruleConcTerm.varType, appliedTerm2);
                appliedTerm2 = Facade.App(appliedTerm.getFunction(), appliedTerm2);
                Util.debug("found a term with assumptions!\n\truleTerm2 = " + ruleTerm2 + "\n\tappliedTerm2 = " + appliedTerm2);
                Util.debug("\n\truleTerm = " + ruleTerm + "\n\tappliedTerm = " + appliedTerm);
                pair = this.checkRuleApplication(term, ruleTerm2, appliedTerm2);
                if (pair != null) {
                    Util.debug("\tadded result!");
                    result.add(pair);
                }
            } else {
                List<? extends Term> args = ((Application)ruleTerm).getArguments();
                Term concTerm = args.get(args.size() - 1);
                int delta = clause.getAdaptationNumber(term, concTerm, false);
                if (delta > 0) {
                    if (ctx.matchTermForAdaptation != null) {
                        Substitution adaptationSub = ctx.adaptationSub == null ? new Substitution() : new Substitution(ctx.adaptationSub);
                        Util.debug("adaptationSub = " + adaptationSub);
                        term = ((ClauseUse)this.conclusion).adaptTermTo(term, ctx.matchTermForAdaptation, adaptationSub);
                    } else {
                        term = ((ClauseUse)this.conclusion).adaptTermTo(term, concTerm, new Substitution());
                    }
                }
                termArgs = this.getFreeVarArgs(term);
                termArgs.add(term);
                appliedTerm = Facade.App((Atom)this.getRuleAppConstant(), termArgs);
                pair = this.checkRuleApplication(term, ruleTerm, appliedTerm);
                if (pair != null) {
                    Util.debug("\tadding " + pair.first);
                    result.add(pair);
                }
            }
        }
        return result;
    }

    private Pair<Term, Substitution> checkRuleApplication(Term term, Term ruleTerm, Term appliedTerm) {
        Substitution sub = null;
        Term fixedRuleTerm = null;
        try {
            sub = ruleTerm.unifyAllowingBVs(appliedTerm);
            Util.debug("found sub " + sub + " for case analyzing " + term + " with rule " + this.getName());
            Set<FreeVar> freeVars = term.getFreeVariables();
            Substitution removeBVSub = new Substitution();
            for (FreeVar v : freeVars) {
                Term substituted = sub.getSubstituted(v);
                if (substituted == null || !substituted.hasBoundVarAbove(0)) continue;
                substituted.removeBoundVarsAbove(0, removeBVSub);
                Term newSubstituted = substituted.substitute(removeBVSub);
                Util.debug("got new substitution: " + newSubstituted);
                sub.add(v, newSubstituted);
            }
            fixedRuleTerm = appliedTerm.substitute(sub).substitute(removeBVSub);
            if (!ruleTerm.equals(fixedRuleTerm)) {
                Util.debug("computed rule term is " + ruleTerm + "\n\tfixed to " + fixedRuleTerm + "\n\tsub is " + sub);
                sub.compose(removeBVSub);
            }
        }
        catch (UnificationFailed e) {
            Util.debug("unification failed on " + ruleTerm + " and " + appliedTerm);
            sub = null;
        }
        if (sub == null) {
            return null;
        }
        return new Pair<Object, Substitution>(fixedRuleTerm, sub);
    }

    @Override
    public String getErrorDescription(Term t, Context ctx) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("rule " + this.getName());
        return sw.toString();
    }
}

