/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrintContext {
    public Term term;
    public List<String> boundVars;
    private Map<String, String> varMap;
    private Set<FreeVar> varsInScope;
    public final String contextVarName;
    public int boundVarCount;

    public PrintContext(Term t, Set<FreeVar> varsInScope, NonTerminal contextVar) {
        Util.verify(t != null, "term is null");
        this.term = t;
        this.varsInScope = varsInScope;
        this.contextVarName = contextVar == null ? "" : contextVar.toString();
        this.varMap = new HashMap<String, String>();
        this.boundVars = new ArrayList<String>();
        this.boundVarCount = 0;
    }

    public PrintContext(Term t, PrintContext ctx) {
        Util.verify(t != null, "term is null");
        this.term = t;
        this.varMap = ctx.varMap;
        this.boundVars = ctx.boundVars;
        this.varsInScope = ctx.varsInScope;
        this.contextVarName = ctx.contextVarName;
        this.boundVarCount = ctx.boundVarCount;
    }

    public String getStringFor(FreeVar term2, String nameRoot) {
        if (this.varsInScope.contains(term2)) {
            return term2.getName();
        }
        String s = this.varMap.get(term2.toString());
        if (s == null) {
            int appendNum = 0;
            while (!this.noConflict(s = String.valueOf(nameRoot) + appendNum)) {
                ++appendNum;
            }
            this.varMap.put(term2.toString(), s);
        }
        return s;
    }

    private boolean noConflict(String s) {
        if (this.varMap.values().contains(s)) {
            return false;
        }
        for (FreeVar v : this.varsInScope) {
            if (!v.toString().equals(s)) continue;
            return false;
        }
        return true;
    }
}

