/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.PrintContext;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.BoundVar;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NonTerminal
extends Element {
    private String symbol;
    private Syntax type;

    public NonTerminal(String s, Location l) {
        super(l);
        this.symbol = s;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Syntax getType() {
        return this.type;
    }

    @Override
    public ElemType getElemType() {
        return this.type;
    }

    @Override
    public Symbol getGrmSymbol() {
        return this.type.getSymbol();
    }

    @Override
    public String getTerminalSymbolString() {
        return this.type.getTermSymbolString();
    }

    @Override
    public Term getTypeTerm() {
        return this.getType().typeTerm();
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NonTerminal)) {
            return false;
        }
        NonTerminal nt = (NonTerminal)obj;
        return this.symbol.equals(nt.symbol);
    }

    public void setType(Syntax t) {
        if (this.type != null && this.type != t) {
            ErrorHandler.report("Internal error: can't reset a NonTerminal's type", (Node)this);
        }
        this.type = t;
    }

    @Override
    public void prettyPrint(PrintWriter out, PrintContext ctx) {
        if (ctx != null) {
            if (ctx.term instanceof FreeVar) {
                out.print(ctx.getStringFor((FreeVar)ctx.term, this.getSymbol()));
            } else if (ctx.term instanceof Application) {
                Application app = (Application)ctx.term;
                String functionName = app.getFunction().getName();
                if (app.getFunction() instanceof Constant) {
                    this.printSubclause(out, ctx, functionName);
                } else {
                    FreeVar var = (FreeVar)app.getFunction();
                    out.print(ctx.getStringFor(var, this.getSymbol()));
                    for (Term term : app.getArguments()) {
                        out.print('[');
                        this.prettyPrint(out, new PrintContext(term, ctx));
                        out.print(']');
                    }
                }
            } else if (ctx.term instanceof Constant) {
                this.printSubclause(out, ctx, ((Constant)ctx.term).getName());
            } else if (ctx.term instanceof BoundVar) {
                out.print(ctx.boundVars.get(ctx.boundVars.size() - ((BoundVar)ctx.term).getIndex()));
            } else {
                out.print(ctx.term);
            }
        } else {
            out.print(this.symbol);
        }
    }

    private void printSubclause(PrintWriter out, PrintContext ctx, String functionName) {
        ClauseDef cd = null;
        for (Clause c : this.type.getClauses()) {
            if (!(c instanceof ClauseDef) || !((ClauseDef)c).getConstructorName().equals(functionName)) continue;
            cd = (ClauseDef)c;
        }
        if (cd == null) {
            System.err.println("couldn't pretty print: " + functionName);
        } else {
            cd.prettyPrint(out, new PrintContext(ctx.term, ctx));
        }
    }

    @Override
    public Element typecheck(Context ctx) {
        NonTerminal nt = this;
        Element e = this;
        String strippedName = Util.stripId(nt.getSymbol());
        Variable var = ctx.varMap.get(strippedName);
        if (var != null) {
            Variable v = new Variable(nt.getSymbol(), nt.getLocation());
            v.setType(var.getType());
            e = v;
        } else {
            Syntax syn = ctx.synMap.get(strippedName);
            if (syn != null) {
                nt.setType(syn);
            } else {
                ErrorHandler.report(Errors.UNDECLARED_NONTERMINAL, "no nonterminal match for " + nt.getSymbol() + "; did you forget to declare " + nt.getSymbol() + " as a terminal?", nt);
            }
        }
        return e;
    }

    @Override
    public FreeVar computeTerm(List<Pair<String, Term>> varBindings) {
        return new FreeVar(this.symbol, this.type.typeTerm());
    }

    @Override
    NonTerminal readAssumptions(List<Pair<String, Term>> varBindings, boolean includeAssumptionTerm) {
        return this;
    }

    @Override
    void checkBindings(Map<String, List<ElemType>> bindingTypes, Node nodeToBlame) {
        ArrayList myType = new ArrayList();
        List<ElemType> prevType = bindingTypes.get(this.getSymbol());
        Util.debug("binding for " + this + " is " + bindingTypes);
        if (prevType == null) {
            bindingTypes.put(this.getSymbol(), myType);
        } else if (!prevType.equals(myType)) {
            ErrorHandler.report(Errors.BINDING_INCONSISTENT, "meta-variable " + this + " must have consistent numbers and types of bindings throughout a rule or branch of a theorem", nodeToBlame);
        }
    }
}

