/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseType;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Rule;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.ast.grammar.GrmRule;
import edu.cmu.cs.sasylf.ast.grammar.GrmUtil;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;

public class Judgment
extends Node
implements ClauseType {
    private List<Rule> rules;
    private Clause form;
    private String name;
    private NonTerminal assume;
    private Constant term = null;

    public Judgment(Location loc, String n, List<Rule> l, Clause c, NonTerminal a) {
        super(loc);
        this.name = n;
        this.rules = l;
        this.form = c;
        this.assume = a;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Clause getForm() {
        return this.form;
    }

    public String getName() {
        return this.name;
    }

    public NonTerminal getAssume() {
        return this.assume;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        out.print("judgment ");
        out.print(this.name);
        out.print(": ");
        this.form.prettyPrint(out);
        out.println();
        if (this.assume != null) {
            out.print("assumes ");
            this.assume.prettyPrint(out);
            out.println();
        }
        out.println();
        for (Rule r : this.getRules()) {
            r.prettyPrint(out);
        }
        out.println("\n");
    }

    public Set<Terminal> getTerminals() {
        return this.form.getTerminals();
    }

    public void defineConstructor(Context ctx) {
        this.form.typecheck(ctx);
        ClauseDef cd = new ClauseDef(this.form, this, this.name);
        cd.checkVarUse(false);
        this.form = cd;
        ctx.parseMap.put(cd.getElemTypes(), cd);
        GrmRule r = new GrmRule(GrmUtil.getStartSymbol(), cd.getSymbols(), cd);
        ctx.ruleSet.add(r);
    }

    public void typecheck(Context ctx) {
        boolean foundAssumeRule = false;
        for (Rule r : this.getRules()) {
            r.typecheck(ctx, this);
            boolean bl = foundAssumeRule = foundAssumeRule || r.isAssumption();
        }
        if (this.getAssume() == null && foundAssumeRule) {
            ErrorHandler.warning(Errors.MISSING_ASSUMES, (Node)this);
        }
    }

    @Override
    public Constant typeTerm() {
        if (this.term == null) {
            this.term = new Constant(this.name, Constant.TYPE);
        }
        return this.term;
    }
}

