/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseAssumption;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Derivation;
import edu.cmu.cs.sasylf.ast.DerivationByAnalysis;
import edu.cmu.cs.sasylf.ast.DerivationByPrevious;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.SyntaxAssumption;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class DerivationWithArgs
extends Derivation {
    private List<Clause> argStrings = new ArrayList<Clause>();
    private List<Fact> args = new ArrayList<Fact>();

    public DerivationWithArgs(String n, Location l, Clause c) {
        super(n, l, c);
    }

    public List<Clause> getArgStrings() {
        return this.argStrings;
    }

    public List<Fact> getArgs() {
        return this.args;
    }

    protected abstract String prettyPrintByClause();

    @Override
    public void prettyPrint(PrintWriter out) {
        super.prettyPrint(out);
        out.print(this.prettyPrintByClause());
        boolean first = true;
        for (Fact arg : this.args) {
            if (first) {
                if (!(this instanceof DerivationByPrevious)) {
                    out.print(" on ");
                }
            } else {
                out.print(", ");
            }
            arg.printReference(out);
            first = false;
        }
        out.println();
    }

    @Override
    public void typecheck(Context ctx) {
        int i = 0;
        while (i < this.argStrings.size()) {
            Clause c = this.argStrings.get(i);
            Fact f = null;
            if (c.getElements().size() == 1 && !(c.getElements().get(0) instanceof Clause)) {
                String s = c.getElements().get(0).toString();
                f = ctx.derivationMap.get(s);
                if (f == null) {
                    f = new SyntaxAssumption(s, this.getLocation());
                    f.typecheck(ctx, true);
                }
            } else {
                Util.debug2("computing fact for " + c + " in class " + this.getClass().getName());
                c = (Clause)c.typecheck(ctx);
                c = (Clause)c.computeClause(ctx, false);
                this.argStrings.set(i, c);
                f = new ClauseAssumption(c, this.getLocation());
                f.typecheck(ctx, true);
            }
            this.args.add(f);
            ++i;
        }
        super.typecheck(ctx);
    }

    protected Term getAdaptedArg(Context ctx, Substitution wrappingSub, int i) {
        Element element = this.getArgs().get(i).getElement();
        Term argTerm = DerivationByAnalysis.adapt(element.asTerm(), element, ctx, false);
        return argTerm;
    }

    protected Term getAdaptedArg(Context ctx, int i) {
        return this.getAdaptedArg(ctx, new Substitution(), i);
    }
}

