/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.DerivationByIHRule;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.RuleLike;
import edu.cmu.cs.sasylf.util.ErrorHandler;

public class DerivationByRule
extends DerivationByIHRule {
    private static int constId = 0;
    private String ruleName;
    private RuleLike rule;

    public DerivationByRule(String n, Location l, Clause c, String rn) {
        super(n, l, c);
        this.ruleName = rn;
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }

    @Override
    public RuleLike getRule(Context ctx) {
        if (this.rule == null) {
            this.rule = ctx.ruleMap.get(this.ruleName);
            if (this.rule == null) {
                this.rule = ctx.recursiveTheorems.get(this.ruleName);
                if (this.rule == null) {
                    ErrorHandler.report(Errors.RULE_NOT_FOUND, this.ruleName, this);
                } else {
                    ErrorHandler.warning(Errors.FORWARD_REFERENCE, (Node)this);
                }
            }
        }
        return this.rule;
    }

    @Override
    public String prettyPrintByClause() {
        return " by rule " + this.ruleName;
    }
}

