/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.DerivationByIHRule;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.RuleLike;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;

public class DerivationByInductionHypothesis
extends DerivationByIHRule {
    public DerivationByInductionHypothesis(String n, Location l, Clause c) {
        super(n, l, c);
    }

    @Override
    public String prettyPrintByClause() {
        return " by induction hypothesis";
    }

    @Override
    public RuleLike getRule(Context ctx) {
        return ctx.currentTheorem;
    }

    @Override
    public String getRuleName() {
        return "induction hypothesis";
    }

    @Override
    public void typecheck(Context ctx) {
        super.typecheck(ctx);
        Fact inductiveArg = this.getArgs().get(ctx.inductionPosition);
        Util.debug("subderivations: " + ctx.subderivations);
        if (!ctx.subderivations.contains(inductiveArg)) {
            ErrorHandler.report(Errors.NOT_SUBDERIVATION, (Node)this);
        }
    }
}

