/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.DerivationByAnalysis;
import edu.cmu.cs.sasylf.ast.DerivationByAssumption;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.SyntaxAssumption;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;

public class DerivationByInduction
extends DerivationByAnalysis {
    public DerivationByInduction(String n, Location l, Clause c, String derivName) {
        super(n, l, c, derivName);
    }

    @Override
    public String byPhrase() {
        return "induction";
    }

    @Override
    public void typecheck(Context ctx) {
        Util.verify(ctx.inductionVariable == null, "can't nest inductions!");
        this.computeTargetDerivation(ctx);
        ctx.inductionVariable = this.getTargetDerivation();
        Util.debug("induction variable " + ctx.inductionVariable + " of type " + ctx.inductionVariable.getClass());
        if (!(this.getTargetDerivation() instanceof DerivationByAssumption) && !(this.getTargetDerivation() instanceof SyntaxAssumption)) {
            ErrorHandler.report("Fact " + this.getTargetDerivationName() + " must be one of the assumed facts in the forall clause of this theorem", (Node)this);
        }
        if (this.getTargetDerivation() instanceof SyntaxAssumption && !((SyntaxAssumption)this.getTargetDerivation()).isTheoremArg()) {
            ErrorHandler.report("Nonterminal " + this.getTargetDerivationName() + " must be an explicit forall clause argument of this theorem", (Node)this);
        }
        ctx.inductionPosition = -1;
        int i = 0;
        while (i < ctx.currentTheorem.getForalls().size()) {
            if (this.getTargetDerivation().equals(ctx.currentTheorem.getForalls().get(i))) {
                ctx.inductionPosition = i;
            }
            ++i;
        }
        if (ctx.inductionPosition == -1) {
            ErrorHandler.report("Fact " + this.getTargetDerivationName() + " must be one of the assumed facts in the forall clause of this theorem", (Node)this);
        }
        super.typecheck(ctx);
    }
}

