/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.DerivationByAnalysis;
import edu.cmu.cs.sasylf.ast.DerivationWithArgs;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.RuleLike;
import edu.cmu.cs.sasylf.ast.Theorem;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.term.UnificationFailed;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DerivationByIHRule
extends DerivationWithArgs {
    public DerivationByIHRule(String n, Location l, Clause c) {
        super(n, l, c);
    }

    public abstract RuleLike getRule(Context var1);

    public abstract String getRuleName();

    @Override
    public void typecheck(Context ctx) {
        super.typecheck(ctx);
        Util.debug("line: " + this.getLocation().getLine());
        if (this.getArgs().size() != this.getRule(ctx).getPremises().size()) {
            ErrorHandler.report(Errors.RULE_PREMISE_NUMBER, this.getRuleName(), this);
        }
        Clause elem = this.getElement();
        Term derivTerm = DerivationByAnalysis.adapt(elem.asTerm(), elem, ctx, false);
        Substitution wrappingSub = new Substitution();
        ArrayList<Term> termArgs = new ArrayList<Term>();
        ArrayList<Term> termArgsWithVar = new ArrayList<Term>();
        HashSet<FreeVar> argFreeVars = new HashSet<FreeVar>();
        int i = 0;
        while (i < this.getArgs().size()) {
            Term argTerm = this.getAdaptedArg(ctx, wrappingSub, i);
            termArgs.add(argTerm);
            termArgsWithVar.add(argTerm);
            argFreeVars.addAll(argTerm.getFreeVariables());
            ++i;
        }
        termArgs.add(derivTerm);
        FreeVar concTermVar = FreeVar.fresh("conclusion", Constant.UNKNOWN_TYPE);
        termArgsWithVar.add(concTermVar);
        Application appliedTerm = Facade.App((Atom)this.getRule(ctx).getRuleAppConstant(), termArgs);
        Application appliedTermWithVar = Facade.App((Atom)this.getRule(ctx).getRuleAppConstant(), termArgsWithVar);
        Term ruleTerm = this.getRule(ctx).getFreshRuleAppTerm(derivTerm, wrappingSub, termArgs);
        try {
            Substitution sub = appliedTerm.unify(ruleTerm);
            HashSet<FreeVar> mustAvoid = new HashSet<FreeVar>(ctx.inputVars);
            if (this.getRule(ctx) instanceof Theorem) {
                List<? extends Term> ruleTermArgs = ((Application)ruleTerm).getArguments();
                Term ruleConcTerm = ruleTermArgs.get(ruleTermArgs.size() - 1);
                Set<FreeVar> ruleConcVarSet = ruleConcTerm.getFreeVariables();
                int i2 = 0;
                while (i2 < ruleTermArgs.size() - 1) {
                    ruleConcVarSet.removeAll(ruleTermArgs.get(i2).getFreeVariables());
                    ++i2;
                }
                mustAvoid.addAll(ruleConcVarSet);
                sub.selectUnavoidable(derivTerm.getFreeVariables());
                HashSet<FreeVar> freshVarSet = new HashSet<FreeVar>();
                for (FreeVar v : ruleConcVarSet) {
                    FreeVar t = v.substitute(sub).getEtaEquivFreeVar();
                    if (t == null) {
                        Util.debug("conclusion " + ruleConcTerm + " ruleConcVarSet was " + ruleConcVarSet + " problem with " + v);
                        ErrorHandler.report(Errors.BAD_RULE_APPLICATION, "The claimed fact is not justified by applying theorem " + this.getRuleName() + " to the argument", this, "incorrectly instantiated a free variable with a term " + t + "\n\twhile unifying " + appliedTerm + " with rule term " + ruleTerm);
                    }
                    freshVarSet.add(t);
                }
                Util.debug("line " + this.getLocation() + " adds vars " + freshVarSet);
                ctx.inputVars.addAll(freshVarSet);
            }
            if (!sub.avoid(mustAvoid)) {
                Util.debug("while unifying " + appliedTerm + " with " + ruleTerm + " and sub " + sub + "\n\ttrying to avoid " + mustAvoid);
                Util.debug("\tctx.inputVars = " + ctx.inputVars);
                Util.debug("\tctx.currentSub = " + ctx.currentSub);
                ErrorHandler.report(Errors.BAD_RULE_APPLICATION, "The claimed fact is not justified by applying rule " + this.getRuleName() + " to the argument", this, "\t(could not remove variables " + ctx.inputVars + " from sub " + sub + ")");
            }
        }
        catch (UnificationFailed e) {
            Term explanationTerm = null;
            try {
                Substitution learnAboutErrors = appliedTermWithVar.unify(ruleTerm);
                explanationTerm = learnAboutErrors.getSubstituted(concTermVar);
            }
            catch (UnificationFailed unificationFailed) {
                // empty catch block
            }
            Util.debug("\tctx.currentSub = " + ctx.currentSub);
            Util.debug("\tctx.adaptationSub = " + ctx.adaptationSub);
            if (explanationTerm == null) {
                ErrorHandler.report(Errors.BAD_RULE_APPLICATION, "The rule cannot legally be applied to the arguments", this, "(was checking " + appliedTerm + " instance of " + ruleTerm + ",\n got exception " + e);
            }
            Util.debug("(was checking " + appliedTerm + " instance of " + ruleTerm + ",\n got exception " + e);
            ErrorHandler.report(Errors.BAD_RULE_APPLICATION, "Claimed fact " + this.getElement() + "\n\tis not a consequence of applying rule " + this.getRuleName() + " to the arguments", this, "SASyLF computed that result LF term should be " + explanationTerm);
        }
    }
}

