/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.AdaptationInfo;
import edu.cmu.cs.sasylf.ast.CanBeCase;
import edu.cmu.cs.sasylf.ast.Case;
import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Derivation;
import edu.cmu.cs.sasylf.ast.DerivationByInduction;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Judgment;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Rule;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.SyntaxAssumption;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DerivationByAnalysis
extends Derivation {
    private List<Case> cases = new ArrayList<Case>();
    private String targetDerivationName;
    private Fact targetDerivation;

    public DerivationByAnalysis(String n, Location l, Clause c, String derivName) {
        super(n, l, c);
        this.targetDerivationName = derivName;
    }

    public String getTargetDerivationName() {
        return this.targetDerivationName;
    }

    protected void computeTargetDerivation(Context ctx) {
        if (this.targetDerivation == null) {
            this.targetDerivation = ctx.derivationMap.get(this.targetDerivationName);
            Util.debug("targetDerivation is " + this.targetDerivation);
            if (this.targetDerivation == null) {
                for (FreeVar v : ctx.inputVars) {
                    if (!this.targetDerivationName.equals(v.getName())) continue;
                    if (this instanceof DerivationByInduction) {
                        ErrorHandler.report("Cannot perform induction over " + this.targetDerivationName + " unless you add this variable as a specific \"forall\" clause of the theorem", (Node)this);
                        continue;
                    }
                    this.targetDerivation = new SyntaxAssumption(this.targetDerivationName, this.getLocation());
                    this.targetDerivation.typecheck(ctx, true);
                    return;
                }
                ErrorHandler.report(Errors.DERIVATION_NOT_FOUND, "Cannot find a derivation named " + this.targetDerivationName, this);
            }
        }
    }

    public Fact getTargetDerivation() {
        return this.targetDerivation;
    }

    public List<Case> getCases() {
        return this.cases;
    }

    public abstract String byPhrase();

    @Override
    public void prettyPrint(PrintWriter out) {
        super.prettyPrint(out);
        out.println(" by " + this.byPhrase() + " on " + this.targetDerivationName + ":");
        for (Case c : this.cases) {
            c.prettyPrint(out);
        }
        out.println("end " + this.byPhrase());
    }

    @Override
    public void typecheck(Context ctx) {
        boolean isSubderivation;
        this.computeTargetDerivation(ctx);
        super.typecheck(ctx, false);
        Term oldCase = ctx.currentCaseAnalysis;
        Element oldElement = ctx.currentCaseAnalysisElement;
        Term oldGoal = ctx.currentGoal;
        Clause oldGoalClause = ctx.currentGoalClause;
        Map<CanBeCase, Set<Pair<Term, Substitution>>> oldCaseTermMap = ctx.caseTermMap;
        ctx.currentCaseAnalysis = DerivationByAnalysis.adapt(this.targetDerivation.getElement().asTerm(), this.targetDerivation.getElement(), ctx, true);
        Util.debug("setting current case analysis to " + ctx.currentCaseAnalysis);
        ctx.currentCaseAnalysisElement = this.targetDerivation.getElement();
        ctx.currentGoal = this.getElement().asTerm().substitute(ctx.currentSub);
        ctx.currentGoalClause = this.getClause();
        boolean bl = isSubderivation = this.targetDerivation != null && (this.targetDerivation.equals(ctx.inductionVariable) || ctx.subderivations.contains(this.targetDerivation));
        if (isSubderivation) {
            Util.debug("found subderivation: " + this.targetDerivation);
        }
        ctx.caseTermMap = new HashMap<CanBeCase, Set<Pair<Term, Substitution>>>();
        if (ctx.currentCaseAnalysisElement instanceof NonTerminal) {
            Syntax syntax = ((NonTerminal)ctx.currentCaseAnalysisElement).getType();
            if (!(ctx.currentCaseAnalysis instanceof FreeVar)) {
                ErrorHandler.report(Errors.VAR_STRUCTURE_KNOWN, "The structure of variable " + ctx.currentCaseAnalysisElement + " is already known and so case analysis is unnecessary (and not currently supported by SASyLF)", this);
            }
            for (Clause clause : syntax.getClauses()) {
                if (clause.isVarOnlyClause()) continue;
                Term term = ((ClauseDef)clause).getSampleTerm();
                Substitution freshSub = term.freshSubstitution(new Substitution());
                term.substitute(freshSub);
                HashSet<Pair<Term, Substitution>> set = new HashSet<Pair<Term, Substitution>>();
                set.add(new Pair<Term, Substitution>(term, new Substitution()));
                ctx.caseTermMap.put(clause, set);
            }
        } else {
            Judgment judgment = (Judgment)((ClauseUse)ctx.currentCaseAnalysisElement).getConstructor().getType();
            Util.debug("*********** case analyzing line " + this.getLocation().getLine());
            for (Rule rule : judgment.getRules()) {
                Set<Pair<Term, Substitution>> caseResult = rule.caseAnalyze(ctx);
                ctx.caseTermMap.put(rule, caseResult);
            }
        }
        for (Case case_ : this.cases) {
            case_.typecheck(ctx, isSubderivation);
        }
        for (Map.Entry entry : ctx.caseTermMap.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            CanBeCase cbc = (CanBeCase)entry.getKey();
            ErrorHandler.report(Errors.MISSING_CASE, cbc.getErrorDescription((Term)((Pair)((Set)entry.getValue()).iterator().next()).first, ctx), this);
        }
        ctx.caseTermMap = oldCaseTermMap;
        ctx.currentCaseAnalysis = oldCase;
        ctx.currentCaseAnalysisElement = oldElement;
        ctx.currentGoal = oldGoal;
        ctx.currentGoalClause = oldGoalClause;
        this.addToDerivationMap(ctx);
    }

    public static Term adapt(Term term, Element element, Context ctx, boolean wrapUnrooted) {
        Util.debug("for element " + element + " term.countLambdas() = " + term.countLambdas());
        if (ctx.adaptationSub != null) {
            Util.debug("ctx.matchTermForAdaptation.countLambdas() = " + ctx.matchTermForAdaptation.countLambdas());
        }
        try {
            if (ctx.adaptationSub != null && term.countLambdas() < ctx.matchTermForAdaptation.countLambdas() && element instanceof ClauseUse && !ctx.innermostGamma.equals(((ClauseUse)element).getRoot())) {
                term = ((ClauseUse)element).adaptTermTo(term, ctx.matchTermForAdaptation, ctx.adaptationSub, wrapUnrooted);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return term.substitute(ctx.currentSub);
    }

    public static Term adapt(Term term, NonTerminal originalContext, Context ctx) {
        NonTerminal targetContext = ctx.innermostGamma;
        Util.debug("adapting from " + originalContext + " to " + targetContext + " on " + term);
        if (originalContext != null && !originalContext.equals(targetContext)) {
            ArrayList<Term> varTypes = new ArrayList<Term>();
            ArrayList<String> varNames = new ArrayList<String>();
            while (!originalContext.equals(targetContext)) {
                AdaptationInfo info = ctx.adaptationMap.get(originalContext);
                if (info == null) {
                    ErrorHandler.report(Errors.UNKNOWN_CONTEXT, "The context variable " + originalContext + " is undefined", originalContext);
                }
                varNames.addAll(info.varNames);
                varTypes.addAll(info.varTypes);
                originalContext = info.nextContext;
            }
            term = ClauseUse.doWrap(term, varNames, varTypes, ctx.adaptationSub == null ? new Substitution() : ctx.adaptationSub);
        } else if (targetContext != null && !targetContext.equals(ctx.adaptationRoot)) {
            Set<FreeVar> varSet = term.getFreeVariables();
            varSet.retainAll(ctx.adaptationSub.getMap().keySet());
            if (!varSet.isEmpty()) {
                Util.debug("adaptation sub = " + ctx.adaptationSub + " applied inside " + ctx.adaptationMap.get((Object)ctx.adaptationRoot).varTypes.size());
                Util.debug("current sub = " + ctx.currentSub);
                term = ((Abstraction)term).subInside(ctx.adaptationSub, ctx.adaptationMap.get((Object)ctx.adaptationRoot).varTypes.size());
                Util.debug("term = " + term);
            }
        }
        return term.substitute(ctx.currentSub);
    }
}

