/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import java.io.PrintWriter;

public abstract class Derivation
extends Fact {
    protected Clause clause;

    public Derivation(String n, Location l, Clause c) {
        super(n, l);
        this.clause = c;
    }

    public Clause getClause() {
        return this.clause;
    }

    @Override
    public Clause getElement() {
        return this.clause;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        out.print(String.valueOf(this.getName()) + ": ");
        this.getClause().prettyPrint(out);
    }

    public void typecheck(Context ctx) {
        this.typecheck(ctx, true);
    }

    @Override
    public void typecheck(Context ctx, boolean addToMap) {
        this.clause.typecheck(ctx);
        Element newClause = this.clause.computeClause(ctx, false);
        if (!(newClause instanceof Clause)) {
            ErrorHandler.report("Expected a judgment, but found a nonterminal.  Did you forget to name the derivation?", (Node)this);
        }
        this.clause = (Clause)newClause;
        this.clause.checkBindings(ctx.bindingTypes, this);
        if (addToMap) {
            this.addToDerivationMap(ctx);
        }
    }
}

