/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Judgment;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.ast.Theorem;
import edu.cmu.cs.sasylf.ast.grammar.GrmRule;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.SASyLFError;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompUnit
extends Node {
    private List<Syntax> syntax;
    private List<Judgment> judgments;
    private List<Theorem> theorems;
    private List<String> name;
    private Set<String> declaredTerminals;

    public CompUnit(List<String> n, Set<String> terms, List<Syntax> s, List<Judgment> j, List<Theorem> t) {
        this.name = n;
        this.declaredTerminals = terms;
        this.syntax = s;
        this.judgments = j;
        this.theorems = t;
    }

    public List<Syntax> getSyntax() {
        return this.syntax;
    }

    public List<Judgment> getJudgments() {
        return this.judgments;
    }

    public List<Theorem> getTheorems() {
        return this.theorems;
    }

    public List<String> getName() {
        return this.name;
    }

    public Set<String> getDeclaredTerminals() {
        return this.declaredTerminals;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        if (this.name.size() > 0) {
            out.print("package ");
            boolean prev = false;
            for (String s : this.name) {
                if (prev) {
                    out.print('.');
                }
                out.print(s);
                prev = true;
            }
            out.println(";\n");
        }
        out.print("terminals ");
        for (Terminal t : this.getTerminals()) {
            if (!Character.isJavaIdentifierStart(t.getSymbol().charAt(0))) continue;
            out.print(t.getGrmSymbol());
            out.print(' ');
        }
        out.println("\n\nsyntax\n");
        for (Syntax s : this.syntax) {
            s.prettyPrint(out);
        }
        for (Judgment j : this.judgments) {
            j.prettyPrint(out);
        }
        for (Theorem t : this.theorems) {
            t.prettyPrint(out);
        }
        out.flush();
    }

    public Set<Terminal> getTerminals() {
        HashSet<Terminal> s = new HashSet<Terminal>();
        for (Syntax syn : this.syntax) {
            s.addAll(syn.getTerminals());
        }
        for (Judgment j : this.judgments) {
            s.addAll(j.getTerminals());
        }
        return s;
    }

    public void getVariables(Context ctx) {
        for (Syntax syn : this.syntax) {
            syn.getVariables(ctx.varMap);
        }
    }

    public boolean typecheck() {
        int oldCount = ErrorHandler.getErrorCount();
        Context ctx = new Context();
        try {
            this.getVariables(ctx);
            this.typecheck(ctx);
        }
        catch (SASyLFError sASyLFError) {
            // empty catch block
        }
        return ErrorHandler.getErrorCount() == oldCount;
    }

    public void typecheck(Context ctx) {
        for (Syntax syntax : this.syntax) {
            if (this.declaredTerminals.contains(syntax.getNonTerminal().getSymbol())) {
                ErrorHandler.report("Syntax nonterminal " + syntax.getNonTerminal().getSymbol() + " may not appear in the terminals list", (Node)syntax.getNonTerminal());
            }
            syntax.computeVarTypes(ctx.varMap);
            ctx.synMap.put(syntax.getNonTerminal().getSymbol(), syntax);
        }
        for (Syntax syntax : this.syntax) {
            syntax.typecheck(ctx);
        }
        this.computeSubordination(ctx);
        for (Judgment judgment : this.judgments) {
            judgment.defineConstructor(ctx);
        }
        Util.debug_parse("Parse Table\n---------------------------");
        for (Map.Entry entry : ctx.parseMap.entrySet()) {
            Util.debug2(entry.toString());
        }
        for (GrmRule grmRule : ctx.ruleSet) {
            Util.debug_parse(grmRule.toString());
        }
        for (Judgment judgment : this.judgments) {
            judgment.typecheck(ctx);
        }
        for (Theorem theorem : this.theorems) {
            try {
                theorem.typecheck(ctx);
            }
            catch (SASyLFError sASyLFError) {
                // empty catch block
            }
        }
    }

    private void computeSubordination(Context ctx) {
        for (Syntax syntax : ctx.synMap.values()) {
            Constant synType = syntax.typeTerm();
            for (Clause clause : syntax.getClauses()) {
                if (!(clause instanceof ClauseDef)) continue;
                ClauseDef clauseDef = (ClauseDef)clause;
                Constant constant = (Constant)clauseDef.asTerm();
                Term typeTerm = constant.getType();
                while (typeTerm instanceof Abstraction) {
                    Abstraction abs = (Abstraction)typeTerm;
                    Term varType = abs.varType;
                    while (varType instanceof Abstraction) {
                        varType = ((Abstraction)varType).getBody();
                    }
                    FreeVar.setAppearsIn(varType, synType);
                    typeTerm = abs.getBody();
                }
            }
        }
        FreeVar.computeAppearsInClosure();
    }
}

