/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Binding;
import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseType;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Judgment;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.SyntaxAssumption;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Substitution;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClauseUse
extends Clause {
    private ClauseDef cons;
    private NonTerminal root;

    public ClauseUse(Location loc, List<Element> elems, ClauseDef cd) {
        super(loc);
        this.elements = elems;
        this.cons = cd;
    }

    public ClauseUse(Clause copy, Map<List<ElemType>, ClauseDef> parseMap) {
        super(copy.getLocation());
        this.getElements().addAll(copy.getElements());
        ArrayList<ElemType> elemTypes = new ArrayList<ElemType>();
        int i = 0;
        while (i < this.getElements().size()) {
            Element e = this.getElements().get(i);
            if (e instanceof Clause) {
                Clause c = (Clause)e;
                ClauseUse cu = new ClauseUse(c, parseMap);
                this.getElements().set(i, cu);
                ClauseType ct = cu.getConstructor().getType();
                if (ct instanceof Judgment) {
                    ErrorHandler.report("A judgment cannot appear inside a clause", (Node)copy);
                }
                ElemType et = (ElemType)((Object)ct);
                elemTypes.add(et);
            } else {
                elemTypes.add(e.getElemType());
            }
            ++i;
        }
        ClauseDef cd = parseMap.get(elemTypes);
        if (cd == null) {
            ErrorHandler.report("Cannot find a syntax constructor or judgment for expression " + copy + " with elements " + elemTypes, (Node)copy);
        }
        this.cons = cd;
    }

    public ClauseDef getConstructor() {
        return this.cons;
    }

    @Override
    public Term getTypeTerm() {
        return this.getConstructor().asTerm();
    }

    public NonTerminal getRoot() {
        return this.root;
    }

    public boolean isRootedInVar() {
        return this.root != null;
    }

    @Override
    public ElemType getElemType() {
        ClauseType ct = this.getConstructor().getType();
        if (ct instanceof Syntax) {
            return (Syntax)ct;
        }
        throw new RuntimeException("should only call getElemTypes on syntax def clauses which don't have sub-clauses; can't call getElemType() on a Clause");
    }

    public Term getBaseTerm() {
        int assumeIndex = this.cons.getAssumeIndex();
        ArrayList<Pair<String, Term>> varBindings = new ArrayList<Pair<String, Term>>();
        if (assumeIndex != -1) {
            this.root = this.getElements().get(assumeIndex).readAssumptions(varBindings, false);
        }
        return this.computeBasicTerm(varBindings, false);
    }

    private Term computeBasicTerm(List<Pair<String, Term>> varBindings, boolean inAssumption) {
        int assumeIndex = this.cons.getAssumeIndex();
        Term cnst = this.cons.computeTerm((List)varBindings);
        ArrayList<Term> args = new ArrayList<Term>();
        Util.debug("converting term " + this + " with assumed vars " + varBindings);
        int i = 0;
        while (i < this.getElements().size()) {
            Element e = this.getElements().get(i);
            if (!(e instanceof Terminal) && i != assumeIndex && !(this.cons.getElements().get(i) instanceof Variable)) {
                Element defE = this.cons.getElements().get(i);
                Term t = null;
                if (defE instanceof Binding) {
                    Binding defB = (Binding)defE;
                    ArrayList<Variable> vars = new ArrayList<Variable>();
                    ArrayList<Pair<String, Term>> newVarBindings = new ArrayList<Pair<String, Term>>(varBindings);
                    int j = defB.getElements().size() - 1;
                    while (j >= 0) {
                        Element varElement;
                        Element boundVarElem = defB.getElements().get(j);
                        int varIndex = this.cons.getIndexOf((Variable)boundVarElem);
                        if (varIndex == -1) {
                            Util.debug("could not find " + boundVarElem + " in clause " + this.cons + "\n    context is " + this);
                        }
                        if (!((varElement = this.getElements().get(varIndex)) instanceof Variable)) {
                            ErrorHandler.report(Errors.EXPECTED_VARIABLE, "Expected variable matching " + boundVarElem + " but found the non-variable " + varElement, varElement);
                        }
                        Variable localVar = (Variable)varElement;
                        String localVarName = localVar.getSymbol();
                        vars.add(localVar);
                        newVarBindings.add(new Pair<String, Constant>(localVarName, localVar.getType().typeTerm()));
                        --j;
                    }
                    t = e.computeTerm(newVarBindings);
                    for (Variable v : vars) {
                        t = Facade.Abs(v.getSymbol(), v.getType().typeTerm(), t);
                    }
                } else {
                    t = inAssumption && e instanceof ClauseUse && ((ClauseUse)e).getConstructor().getType().equals(this.cons.getType()) ? Facade.FreshVar("AssumptionVar", Constant.UNKNOWN_TYPE) : e.computeTerm(varBindings);
                }
                args.add(t);
            }
            ++i;
        }
        return args.size() > 0 ? new Application((Atom)cnst, args) : cnst;
    }

    @Override
    public Term computeTerm(List<Pair<String, Term>> varBindings) {
        int assumeIndex = this.cons.getAssumeIndex();
        int initialBindingsSize = varBindings.size();
        if (assumeIndex != -1) {
            Util.verify(varBindings.size() == 0, "assume rule with nonempty var bindings");
            this.root = this.getElements().get(assumeIndex).readAssumptions(varBindings, true);
        }
        Term t = this.computeBasicTerm(varBindings, false);
        if (assumeIndex != -1) {
            int i = varBindings.size() - 1;
            while (i >= initialBindingsSize) {
                t = Facade.Abs((String)varBindings.get((int)i).first, (Term)varBindings.get((int)i).second, t);
                --i;
            }
        }
        Util.debug("    conversion result is " + t);
        return t;
    }

    public List<Fact> getNonTerminals() {
        int assumeIndex = this.getConstructor().getAssumeIndex();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        int i = 0;
        while (i < this.getElements().size()) {
            Element e = this.getElements().get(i);
            if (!(e instanceof Terminal) && i != assumeIndex && !(e instanceof Variable)) {
                if (e instanceof Binding) {
                    ErrorHandler.report("Can't case analyze bindings", (Node)this);
                } else if (e instanceof NonTerminal) {
                    facts.add(new SyntaxAssumption((NonTerminal)e));
                } else {
                    if (e instanceof Clause) {
                        throw new RuntimeException("should be impossible case");
                    }
                    throw new RuntimeException("should be impossible case");
                }
            }
            ++i;
        }
        return facts;
    }

    @Override
    NonTerminal readAssumptions(List<Pair<String, Term>> varBindings, boolean includeAssumptionTerm) {
        boolean foundClause = false;
        for (Element e : this.getElements()) {
            if (e instanceof ClauseUse && ((ClauseUse)e).getConstructor().getType().equals(this.cons.getType())) {
                if (foundClause) {
                    ErrorHandler.report("An assumption case must not have more than one nested list of assumptions", (Node)this.cons);
                }
                foundClause = true;
                this.root = e.readAssumptions(varBindings, includeAssumptionTerm);
                continue;
            }
            if (!(e instanceof NonTerminal) || !((NonTerminal)e).getType().equals(this.cons.getType())) continue;
            if (foundClause) {
                ErrorHandler.report("An assumption case must not have more than one nested list of assumptions", (Node)this.cons);
            }
            foundClause = true;
            this.root = (NonTerminal)e;
        }
        boolean foundVar = false;
        for (Element e : this.getElements()) {
            if (!(e instanceof Variable)) continue;
            Variable v = (Variable)e;
            if (foundVar) {
                ErrorHandler.report("An assumption case must not have more than one variable", (Node)this.cons);
            }
            foundVar = true;
            String derivSym = "INTERNAL_DERIV_" + v.getSymbol();
            if (this.cons.assumptionRule == null) {
                ErrorHandler.report(Errors.MISSING_ASSUMPTION_RULE, "There's no rule for using an assumption of the form " + this.cons, this.cons);
            }
            ClauseUse varRuleConc = (ClauseUse)this.cons.assumptionRule.getConclusion();
            Term derivTerm = includeAssumptionTerm ? varRuleConc.getBaseTerm() : null;
            Term myClauseTerm = this.computeBasicTerm(varBindings, true);
            ClauseUse varRuleConcAssumption = (ClauseUse)varRuleConc.getElements().get(varRuleConc.cons.getAssumeIndex());
            Term ruleClauseTerm = varRuleConcAssumption.getBaseTerm();
            Substitution ruleFreshSub = new Substitution();
            ruleClauseTerm.freshSubstitution(ruleFreshSub);
            ruleClauseTerm = ruleClauseTerm.substitute(ruleFreshSub);
            Substitution bindingSub = new Substitution();
            ArrayList<Term> varTypes = new ArrayList<Term>();
            for (Pair<String, Term> p : varBindings) {
                varTypes.add((Term)p.second);
            }
            Util.debug("varTypes = " + varTypes);
            ruleClauseTerm.bindInFreeVars(varTypes, bindingSub, 1);
            ruleClauseTerm = ruleClauseTerm.substitute(bindingSub);
            Util.debug("unifying terms " + myClauseTerm + " and " + ruleClauseTerm + " from " + this + " and " + varRuleConcAssumption);
            Substitution adaptationSub = myClauseTerm.unifyAllowingBVs(ruleClauseTerm);
            adaptationSub.avoid(myClauseTerm.getFreeVariables());
            Util.debug("adaptationSub = " + adaptationSub);
            if (derivTerm != null) {
                Util.debug("\torig   derivTerm = " + derivTerm);
                derivTerm.freshSubstitution(ruleFreshSub);
                derivTerm = derivTerm.substitute(ruleFreshSub);
                bindingSub.incrFreeDeBruijn(2);
                derivTerm = derivTerm.substitute(bindingSub);
                Util.debug("\tmiddle derivTerm = " + derivTerm);
                derivTerm = derivTerm.substitute(adaptationSub);
                derivTerm = derivTerm.incrFreeDeBruijn(-1);
            }
            Util.debug("\tresult derivTerm = " + derivTerm);
            varBindings.add(Facade.pair(v.getSymbol(), v.getType().typeTerm()));
            varBindings.add(Facade.pair(derivSym, derivTerm));
        }
        return this.root;
    }

    @Override
    public Term adaptTermTo(Term term, Term matchTerm, Substitution sub) {
        return this.adaptTermTo(term, matchTerm, sub, false);
    }

    public Term adaptTermTo(Term term, Term matchTerm, Substitution sub, boolean wrapUnrooted) {
        Term result = this.wrapWithOuterLambdas(term, matchTerm, this.getAdaptationNumber(term, matchTerm, wrapUnrooted), sub, wrapUnrooted);
        Util.debug("adapation of " + term + " to " + result + " with sub " + sub + "\n\tsub applied is: " + term.substitute(sub));
        return result;
    }

    public int getAdaptationNumber(Term term, Term matchTerm, boolean wrapUnrooted) {
        if (this.isRootedInVar() || wrapUnrooted) {
            int matchLambdas;
            int termLambdas = term.countLambdas();
            if (termLambdas >= (matchLambdas = matchTerm.countLambdas())) {
                return 0;
            }
            return matchLambdas - termLambdas;
        }
        return 0;
    }

    public Term wrapWithOuterLambdas(Term term, Term matchTerm, int i) {
        return this.wrapWithOuterLambdas(term, matchTerm, i, new Substitution(), false);
    }

    public Term wrapWithOuterLambdas(Term term, Term matchTerm, int i, Substitution sub, boolean wrapUnrooted) {
        if (i == 0 || !this.isRootedInVar() && !wrapUnrooted) {
            return term;
        }
        Abstraction absMatchTerm = (Abstraction)matchTerm;
        ArrayList<Term> varTypes = new ArrayList<Term>();
        ArrayList<String> varNames = new ArrayList<String>();
        ClauseUse.readNamesAndTypes(absMatchTerm, i, varNames, varTypes);
        return ClauseUse.doWrap(term, varNames, varTypes, sub);
    }

    public static void readNamesAndTypes(Abstraction absMatchTerm, int i, List<String> varNames, List<Term> varTypes) {
        int j = 0;
        while (j < i) {
            varTypes.add(absMatchTerm.varType);
            varNames.add(absMatchTerm.varName);
            if (j < i - 1) {
                absMatchTerm = (Abstraction)absMatchTerm.getBody();
            }
            ++j;
        }
    }

    public static Term doWrap(Term term, List<String> varNames, List<Term> varTypes, Substitution sub) {
        Util.debug("before binding in free vars: " + term.substitute(sub) + " with types " + varTypes);
        term.bindInFreeVars(varTypes, sub, 1);
        term = term.substitute(sub);
        Util.debug("after binding in free vars: " + term + " with sub " + sub);
        int j = varNames.size() - 1;
        while (j >= 0) {
            term = Abstraction.make(varNames.get(j), varTypes.get(j), term);
            --j;
        }
        return term;
    }

    public Term oldWrapWithOuterLambdas(Term term, Term matchTerm, int i, Substitution sub) {
        if (i == 0 || !this.isRootedInVar()) {
            return term;
        }
        Abstraction absMatchTerm = (Abstraction)matchTerm;
        term = this.oldWrapWithOuterLambdas(term, absMatchTerm.getBody(), i - 1, sub);
        Util.debug("before binding in free vars: " + term.substitute(sub));
        term.bindInFreeVars(absMatchTerm.varType, sub);
        term = term.substitute(sub);
        Util.debug("after binding in free vars: " + term + " with sub " + sub);
        return Abstraction.make(absMatchTerm.varName, absMatchTerm.varType, term);
    }
}

