/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Binding;
import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.ClauseType;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Judgment;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.PrintContext;
import edu.cmu.cs.sasylf.ast.Rule;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Constant;
import edu.cmu.cs.sasylf.term.Facade;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClauseDef
extends Clause {
    private String consName;
    private ClauseType type;
    public Rule assumptionRule;
    private static int uniqueint = 0;
    private static Set<String> strings = new HashSet<String>();

    public ClauseDef(Clause copy, ClauseType type) {
        this(copy, type, null);
    }

    public ClauseDef(Clause copy, ClauseType type, String cName) {
        super(copy.getLocation());
        this.getElements().addAll(copy.getElements());
        this.type = type;
        if (cName != null) {
            this.consName = cName;
        } else {
            this.consName = "C";
            for (Element e : this.getElements()) {
                if (!(e instanceof Terminal)) continue;
                Terminal t = (Terminal)e;
                this.consName = String.valueOf(this.consName) + '_' + t.getSymbol();
            }
            this.consName = ClauseDef.uniqueify(this.consName);
        }
    }

    public String getConstructorName() {
        return this.consName;
    }

    public ClauseType getType() {
        return this.type;
    }

    public int getAssumeIndex() {
        if (this.type instanceof Judgment) {
            NonTerminal assumeNT = ((Judgment)this.type).getAssume();
            return this.getElements().indexOf(assumeNT);
        }
        return -1;
    }

    @Override
    public Term getTypeTerm() {
        return this.asTerm();
    }

    private static String uniqueify(String s) {
        String result = s;
        if (strings.contains(s)) {
            result = String.valueOf(s) + uniqueint++;
        }
        strings.add(result);
        return result;
    }

    @Override
    public Constant computeTerm(List<Pair<String, Term>> varBindings) {
        Term typeTerm = this.type.typeTerm();
        int assumeIndex = this.getAssumeIndex();
        ArrayList<Term> argTypes = new ArrayList<Term>();
        int i = 0;
        while (i < this.getElements().size()) {
            Element e = this.getElements().get(i);
            if (!(e instanceof Terminal) && i != assumeIndex && !(e instanceof Variable)) {
                Term argType = null;
                if (e instanceof Binding) {
                    Binding defB = (Binding)e;
                    argType = defB.getNonTerminal().getType().typeTerm();
                    ArrayList<Term> varTypes = new ArrayList<Term>();
                    for (Element boundVarElem : defB.getElements()) {
                        int varIndex = this.getIndexOf((Variable)boundVarElem);
                        if (varIndex == -1) {
                            ErrorHandler.report("could not find " + boundVarElem + " in clause " + this, (Node)this);
                        }
                        Variable localVar = (Variable)this.getElements().get(varIndex);
                        varTypes.add(localVar.getType().typeTerm());
                    }
                    argType = Term.wrapWithLambdas(argType, varTypes);
                } else if (e instanceof NonTerminal) {
                    argType = ((NonTerminal)e).getType().typeTerm();
                } else if (e instanceof Clause) {
                    argType = ((ClauseUse)e).getConstructor().asTerm();
                } else {
                    throw new RuntimeException("should be impossible case");
                }
                argTypes.add(argType);
            }
            ++i;
        }
        typeTerm = Term.wrapWithLambdas(typeTerm, argTypes);
        return new Constant(this.consName, typeTerm);
    }

    public int getIndexOf(Variable boundVar) {
        return this.getElements().indexOf(boundVar);
    }

    public Term getSampleTerm() {
        Constant constant = (Constant)this.asTerm();
        Term typeTerm = constant.getType();
        ArrayList<FreeVar> arguments = new ArrayList<FreeVar>();
        while (typeTerm instanceof Abstraction) {
            Abstraction abs = (Abstraction)typeTerm;
            FreeVar var = Facade.FreshVar(abs.varName, abs.varType);
            arguments.add(var);
            typeTerm = abs.getBody();
        }
        return constant.apply(arguments, 0);
    }

    public void checkVarUse(boolean isContext) {
        HashSet<Variable> topVars = new HashSet<Variable>();
        HashSet<Variable> boundVars = new HashSet<Variable>();
        int i = 0;
        while (i < this.elements.size()) {
            Element e = (Element)this.elements.get(i);
            if (e instanceof Variable) {
                topVars.add((Variable)e);
            }
            if (e instanceof Binding) {
                for (Element boundE : ((Binding)e).getElements()) {
                    if (boundE instanceof Variable) {
                        boundVars.add((Variable)boundE);
                        continue;
                    }
                    ErrorHandler.report("Syntax and judgment definitions may only have variables inside bindings", (Node)boundE);
                }
            }
            ++i;
        }
        if (!topVars.equals(boundVars)) {
            if (!topVars.containsAll(boundVars)) {
                boundVars.removeAll(topVars);
                ErrorHandler.report("Variable(s) " + boundVars + " were used in a binding but never declared", (Node)this);
            } else {
                topVars.removeAll(boundVars);
                if (!isContext) {
                    ErrorHandler.report(Errors.UNBOUND_VAR_USE, "Variable(s) " + topVars + " were used at the top level of this syntax or judgment form.  SASyLF assumes you are declaring this variable, but the variable is not bound in any expression.", this);
                }
            }
        }
    }

    @Override
    public void prettyPrint(PrintWriter out, PrintContext ctx) {
        Term origT;
        Term t = origT = ctx == null ? null : ctx.term;
        List<String> origBoundVars = ctx == null ? null : ctx.boundVars;
        int origBoundVarCount = ctx == null ? 0 : ctx.boundVarCount;
        HashSet<String> ctxVars = null;
        if (ctx != null && this.getAssumeIndex() != -1 && t instanceof Abstraction) {
            ctxVars = new HashSet<String>();
            ctx.boundVars = new ArrayList<String>(ctx.boundVars);
            while (t instanceof Abstraction) {
                String varName = "<aVar" + ctx.boundVarCount + ">";
                ctx.boundVars.add(varName);
                ctxVars.add(varName);
                t = ((Abstraction)t).getBody();
                if (t instanceof Abstraction) {
                    t = ((Abstraction)t).getBody();
                    ctx.boundVars.add("<aVar" + ctx.boundVarCount + "assumption>");
                }
                ++ctx.boundVarCount;
            }
        }
        boolean prev = false;
        Iterator<? extends Term> termIter = null;
        if (ctx != null && t instanceof Application) {
            List<? extends Term> elemTerms = ((Application)t).getArguments();
            termIter = elemTerms.iterator();
        }
        int i = 0;
        while (i < this.elements.size()) {
            Element e = (Element)this.elements.get(i);
            if (prev) {
                out.print(' ');
            }
            if (e instanceof Clause) {
                out.print('(');
            }
            t = null;
            if (!(e instanceof Terminal) && !(e instanceof Variable) && termIter != null && termIter.hasNext() && i != this.getAssumeIndex()) {
                t = termIter.next();
            }
            if (ctx != null && i == this.getAssumeIndex()) {
                out.print(ctx.contextVarName);
                if (origT instanceof Abstraction) {
                    out.print("<expanded with vars:" + ctxVars + ">");
                }
            } else {
                e.prettyPrint(out, t == null ? null : new PrintContext(t, ctx));
            }
            if (e instanceof Clause) {
                out.print(')');
            }
            prev = true;
            ++i;
        }
        if (origBoundVars != null) {
            ctx.boundVars = origBoundVars;
            ctx.boundVarCount = origBoundVarCount;
        }
    }
}

