/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Binding;
import edu.cmu.cs.sasylf.ast.CanBeCase;
import edu.cmu.cs.sasylf.ast.ClauseDef;
import edu.cmu.cs.sasylf.ast.ClauseUse;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.PrintContext;
import edu.cmu.cs.sasylf.ast.Syntax;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.ast.Variable;
import edu.cmu.cs.sasylf.ast.grammar.GrmRule;
import edu.cmu.cs.sasylf.ast.grammar.GrmTerminal;
import edu.cmu.cs.sasylf.ast.grammar.GrmUtil;
import edu.cmu.cs.sasylf.grammar.AmbiguousSentenceException;
import edu.cmu.cs.sasylf.grammar.Grammar;
import edu.cmu.cs.sasylf.grammar.NotParseableException;
import edu.cmu.cs.sasylf.grammar.ParseNode;
import edu.cmu.cs.sasylf.grammar.RuleNode;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.grammar.TerminalNode;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Clause
extends Element
implements CanBeCase {
    protected List<Element> elements = new ArrayList<Element>();

    public Clause(Location l) {
        super(l);
        Util.verify(this.getLocation() != null, "location provided is null!");
    }

    public Clause(Element e) {
        super(e.getLocation());
        Util.verify(this.getLocation() != null, "location null for " + e + " of type " + e.getClass());
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<ElemType> getElemTypes() {
        ArrayList<ElemType> list = new ArrayList<ElemType>();
        for (Element e : this.elements) {
            list.add(e.getElemType());
        }
        return list;
    }

    private List<GrmTerminal> getTerminalSymbols() {
        ArrayList<GrmTerminal> list = new ArrayList<GrmTerminal>();
        for (Element e : this.elements) {
            if (e instanceof Clause) {
                List<GrmTerminal> sublist = ((Clause)e).getTerminalSymbols();
                list.add(GrmUtil.terminalFor("("));
                list.addAll(sublist);
                list.add(GrmUtil.terminalFor(")"));
                continue;
            }
            list.add(e.getTerminalSymbol());
        }
        return list;
    }

    public List<Symbol> getSymbols() {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (Element e : this.elements) {
            list.add(e.getGrmSymbol());
        }
        return list;
    }

    @Override
    public ElemType getElemType() {
        throw new RuntimeException("should only call getElemTypes on syntax def clauses which don't have sub-clauses; can't call getElemType() on a Clause");
    }

    @Override
    public Symbol getGrmSymbol() {
        throw new RuntimeException("should only call getSymbols on syntax def clauses which don't have sub-clauses; can't call getSymbol() on a Clause");
    }

    @Override
    protected String getTerminalSymbolString() {
        throw new RuntimeException("should only call getTerminalSymbols on clauses which don't have sub-clauses; can't call getTerminalSymbol() on a Clause");
    }

    public boolean isVarOnlyClause() {
        return this.elements.size() == 1 && this.elements.get(0) instanceof Variable;
    }

    @Override
    public void prettyPrint(PrintWriter out, PrintContext ctx) {
        boolean prev = false;
        for (Element e : this.elements) {
            if (prev) {
                out.print(' ');
            }
            if (e instanceof Clause) {
                out.print('(');
            }
            e.prettyPrint(out, null);
            if (e instanceof Clause) {
                out.print(')');
            }
            prev = true;
        }
    }

    public Set<Terminal> getTerminals() {
        HashSet<Terminal> s = new HashSet<Terminal>();
        for (Element e : this.elements) {
            if (!(e instanceof Terminal)) continue;
            s.add((Terminal)e);
        }
        return s;
    }

    public void getVariables(Map<String, Variable> map) {
        for (Element e : this.elements) {
            if (!(e instanceof Binding)) continue;
            for (Element e2 : ((Binding)e).getElements()) {
                NonTerminal nt;
                String key;
                if (!(e2 instanceof NonTerminal)) {
                    ErrorHandler.report("Only variables are permitted inside a binding on the right hand side of a syntax definition", (Node)e2);
                }
                if (map.containsKey(key = (nt = (NonTerminal)e2).getSymbol())) continue;
                map.put(key, new Variable(key, nt.getLocation()));
            }
        }
    }

    public void computeVarTypes(Syntax parent, Map<String, Variable> varMap) {
        NonTerminal nt;
        Variable var;
        if (this.elements.size() == 1 && this.elements.get(0) instanceof NonTerminal && (var = varMap.get((nt = (NonTerminal)this.elements.get(0)).getSymbol())) != null) {
            var.setType(parent);
        }
    }

    @Override
    public Element typecheck(Context ctx) {
        int i = 0;
        while (i < this.elements.size()) {
            Element e = this.elements.get(i);
            this.elements.set(i, this.elements.get(i).typecheck(ctx));
            ++i;
        }
        return this;
    }

    public Element computeClause(Context ctx, boolean inBinding) {
        return this.computeClause(ctx, inBinding, ctx.getGrammar());
    }

    /*
     * Unable to fully structure code
     */
    public Element computeClause(Context ctx, boolean inBinding, Grammar g) {
        block7: {
            symList = this.getTerminalSymbols();
            parseTree = null;
            try {
                parseTree = g.parse(symList);
                return this.computeClause(parseTree);
            }
            catch (NotParseableException e) {
                ErrorHandler.report("Cannot parse any syntactic case or judgment for expression " + this, (Node)this);
                throw new RuntimeException("should be unreachable");
            }
            catch (AmbiguousSentenceException e) {
                if (e.getParseTrees().size() == 1) {
                    Util.debug_parse("ambiguous parse trees are actually equal!");
                }
                if (!inBinding) break block7;
                varTypes = new HashSet<String>();
                ** for (v : ctx.varMap.values())
            }
lbl-1000:
            // 1 sources

            {
                varTypes.add(v.getType().toString());
                continue;
            }
lbl18:
            // 1 sources

            keptTrees = new HashSet<RuleNode>();
            for (RuleNode tree : e.getParseTrees()) {
                key = ((RuleNode)tree.getChildren().get(0)).getRule().getLeftSide().toString();
                if (!varTypes.contains(key)) continue;
                keptTrees.add(tree);
            }
            if (keptTrees.size() == 1) {
                parseTree = (RuleNode)keptTrees.iterator().next();
                return this.computeClause(parseTree);
            }
        }
        ErrorHandler.report("Ambiguous expression " + this + " has differing parse trees " + e.getParseTrees(), (Node)this);
        throw new RuntimeException("should be unreachable");
    }

    private Element computeClause(RuleNode parseTree) {
        ArrayList<Element> newElements = new ArrayList<Element>();
        for (ParseNode p : parseTree.getChildren()) {
            if (p instanceof RuleNode) {
                newElements.add(this.computeClause((RuleNode)p));
                continue;
            }
            GrmTerminal n = (GrmTerminal)((TerminalNode)p).getTerminal();
            if (n.getElement() == null) continue;
            newElements.add(n.getElement());
        }
        ClauseDef cd = ((GrmRule)parseTree.getRule()).getClauseDef();
        if (cd == null) {
            Element e;
            if (newElements.size() == 1 && newElements.get(0) instanceof ClauseUse && parseTree.getRule().getLeftSide().equals(GrmUtil.getStartSymbol()) && ((ClauseUse)newElements.get(0)).getConstructor().getType() instanceof Syntax) {
                return (ClauseUse)newElements.get(0);
            }
            if (newElements.size() == 1 && ((e = (Element)newElements.get(0)) instanceof Binding || e instanceof NonTerminal || e instanceof Variable)) {
                return e;
            }
            ErrorHandler.report("internal error: not sure what to do with null ClauseUse on " + newElements, (Node)this);
        }
        return new ClauseUse(this.getLocation(), newElements, cd);
    }

    @Override
    public Term computeTerm(List<Pair<String, Term>> varBindings) {
        throw new RuntimeException("internal error: can't compute the term before typechecking");
    }

    @Override
    void checkBindings(Map<String, List<ElemType>> bindingTypes, Node nodeToBlame) {
        for (Element e : this.elements) {
            e.checkBindings(bindingTypes, nodeToBlame);
        }
    }

    @Override
    public String getErrorDescription(Term t, Context ctx) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.prettyPrint(pw, new PrintContext(t, ctx.inputVars, ctx.innermostGamma));
            return sw.toString();
        }
        return this.toString();
    }
}

