/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.Derivation;
import edu.cmu.cs.sasylf.ast.Fact;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.Theorem;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Case
extends Node {
    private List<Derivation> derivations = new ArrayList<Derivation>();

    public Case(Location l) {
        super(l);
    }

    public List<Derivation> getDerivations() {
        return this.derivations;
    }

    @Override
    public void prettyPrint(PrintWriter out) {
        for (Derivation d : this.derivations) {
            d.prettyPrint(out);
        }
        out.println("end case\n");
    }

    public void typecheck(Context ctx, boolean isSubderivation) {
        Map<String, Fact> oldMap = ctx.derivationMap;
        ctx.derivationMap = new HashMap<String, Fact>(oldMap);
        for (Derivation d : this.derivations) {
            d.typecheck(ctx);
        }
        Theorem.verifyLastDerivation(ctx, ctx.currentGoal, ctx.currentGoalClause, this.derivations, this);
        ctx.derivationMap = oldMap;
    }
}

