/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf.ast;

import edu.cmu.cs.sasylf.ast.Clause;
import edu.cmu.cs.sasylf.ast.Context;
import edu.cmu.cs.sasylf.ast.ElemType;
import edu.cmu.cs.sasylf.ast.Element;
import edu.cmu.cs.sasylf.ast.Errors;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.ast.Node;
import edu.cmu.cs.sasylf.ast.NonTerminal;
import edu.cmu.cs.sasylf.ast.PrintContext;
import edu.cmu.cs.sasylf.ast.Terminal;
import edu.cmu.cs.sasylf.grammar.Symbol;
import edu.cmu.cs.sasylf.term.Abstraction;
import edu.cmu.cs.sasylf.term.Application;
import edu.cmu.cs.sasylf.term.Atom;
import edu.cmu.cs.sasylf.term.FreeVar;
import edu.cmu.cs.sasylf.term.Pair;
import edu.cmu.cs.sasylf.term.Term;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Binding
extends Element {
    private List<Element> elements;
    private NonTerminal nonTerminal;

    public Binding(Location loc, NonTerminal nt, List<Element> l) {
        super(loc);
        this.nonTerminal = nt;
        this.elements = l;
    }

    public NonTerminal getNonTerminal() {
        return this.nonTerminal;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    public ElemType getElemType() {
        return this.nonTerminal.getType();
    }

    @Override
    public Symbol getGrmSymbol() {
        return this.nonTerminal.getGrmSymbol();
    }

    @Override
    public String getTerminalSymbolString() {
        return this.nonTerminal.getType().getTermSymbolString();
    }

    @Override
    public void prettyPrint(PrintWriter out, PrintContext ctx) {
        if (ctx != null) {
            ctx.boundVars = new ArrayList<String>(ctx.boundVars);
            String varName = "<aVar" + ctx.boundVarCount++ + ">";
            ctx.boundVars.add(varName);
            Term t = ctx.term;
            if (t instanceof Abstraction) {
                t = ((Abstraction)t).getBody();
            }
            this.nonTerminal.prettyPrint(out, new PrintContext(t, ctx));
        } else {
            this.nonTerminal.prettyPrint(out);
            for (Element e : this.elements) {
                out.print('[');
                e.prettyPrint(out);
                out.print(']');
            }
        }
    }

    @Override
    public Element typecheck(Context ctx) {
        Element e = this.nonTerminal.typecheck(ctx);
        if (!(e instanceof NonTerminal)) {
            ErrorHandler.report("A binder must have a nonterminal as the thing bound in", (Node)this.nonTerminal);
        }
        this.nonTerminal = (NonTerminal)e;
        int i = 0;
        while (i < this.elements.size()) {
            Clause c;
            Element e2 = this.elements.get(i).typecheck(ctx);
            if (e2 instanceof Terminal) {
                c = new Clause(e2);
                c.getElements().add(e2);
                e2 = c;
            }
            if (e2 instanceof Clause) {
                Element cu;
                c = (Clause)e2;
                e2 = cu = c.computeClause(ctx, true);
            }
            this.elements.set(i, e2);
            ++i;
        }
        return this;
    }

    @Override
    public Term computeTerm(List<Pair<String, Term>> varBindings) {
        Term t = this.nonTerminal.computeTerm((List)varBindings);
        ArrayList<Term> argList = new ArrayList<Term>();
        ArrayList<Term> argTypes = new ArrayList<Term>();
        for (Element e : this.elements) {
            Term argT = e.computeTerm(varBindings);
            argList.add(argT);
            argTypes.add(argT.getType(varBindings));
        }
        Term varType = ((FreeVar)t).getType();
        varType = Term.wrapWithLambdas(varType, argTypes);
        ((FreeVar)t).setType(varType);
        return new Application((Atom)t, argList);
    }

    @Override
    void checkBindings(Map<String, List<ElemType>> bindingTypes, Node nodeToBlame) {
        ArrayList<ElemType> myType = new ArrayList<ElemType>();
        for (Element e : this.elements) {
            myType.add(e.getElemType());
        }
        List<ElemType> prevType = bindingTypes.get(this.getNonTerminal().getSymbol());
        Util.debug("binding for " + this + " is " + bindingTypes);
        if (prevType == null) {
            bindingTypes.put(this.getNonTerminal().getSymbol(), myType);
        } else if (!prevType.equals(myType)) {
            ErrorHandler.report(Errors.BINDING_INCONSISTENT, "meta-variable " + this.nonTerminal + " must have consistent numbers and types of bindings throughout a rule or branch of a theorem", nodeToBlame);
        }
    }
}

