/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sasylf;

import edu.cmu.cs.sasylf.ast.CompUnit;
import edu.cmu.cs.sasylf.ast.Location;
import edu.cmu.cs.sasylf.parser.DSLToolkitParser;
import edu.cmu.cs.sasylf.parser.ParseException;
import edu.cmu.cs.sasylf.util.ErrorHandler;
import edu.cmu.cs.sasylf.util.SASyLFError;
import edu.cmu.cs.sasylf.util.Util;
import java.io.File;
import java.io.FileNotFoundException;

public class Main {
    public static void main(String[] args) throws FileNotFoundException, ParseException {
        if (args.length == 0 || args.length == 1 && args[0].equals("--help")) {
            System.err.println("usage: sasylf file1.slf");
            System.err.println("   or: sasylf --version");
            System.err.println("   or: sasylf --help");
            System.err.println("   or: sasylf --verbose (prints out theorem names as it checks them)");
            System.err.println("   or: sasylf --LF file1.slf (extra info about LF terms in certain error messages)");
            return;
        }
        int oldErrorCount = 0;
        if (args.length == 1 && args[0].equals("--version")) {
            System.out.println("SASyLF version 1.0.2");
            return;
        }
        int i = 0;
        while (i < args.length) {
            block29: {
                if (args[i].equals("--LF")) {
                    Util.EXTRA_ERROR_INFO = true;
                } else if (args[i].equals("--verbose")) {
                    Util.VERBOSE = true;
                } else {
                    int newErrorCount;
                    String filename = args[i];
                    File file = new File(filename);
                    if (!file.canRead()) {
                        System.err.println("Could not open file " + filename);
                        return;
                    }
                    try {
                        CompUnit cu = null;
                        try {
                            cu = DSLToolkitParser.read(file);
                        }
                        catch (ParseException e) {
                            ErrorHandler.report(null, e.getMessage(), new Location(e.currentToken.next), null, true, false);
                        }
                        cu.typecheck();
                    }
                    catch (SASyLFError cu) {
                        newErrorCount = ErrorHandler.getErrorCount() - oldErrorCount;
                        oldErrorCount = ErrorHandler.getErrorCount();
                        if (newErrorCount == 0) {
                            System.out.println(String.valueOf(filename) + ": No errors found.");
                        } else if (newErrorCount == 1) {
                            System.err.println(String.valueOf(filename) + ": 1 error found");
                        } else {
                            System.err.println(String.valueOf(filename) + ": " + newErrorCount + " errors found");
                        }
                        break block29;
                    }
                    catch (RuntimeException e) {
                        try {
                            System.err.println("Internal SASyLF error!");
                            e.printStackTrace();
                            break block29;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            newErrorCount = ErrorHandler.getErrorCount() - oldErrorCount;
                            oldErrorCount = ErrorHandler.getErrorCount();
                            if (newErrorCount == 0) {
                                System.out.println(String.valueOf(filename) + ": No errors found.");
                            } else if (newErrorCount == 1) {
                                System.err.println(String.valueOf(filename) + ": 1 error found");
                            } else {
                                System.err.println(String.valueOf(filename) + ": " + newErrorCount + " errors found");
                            }
                        }
                    }
                    newErrorCount = ErrorHandler.getErrorCount() - oldErrorCount;
                    oldErrorCount = ErrorHandler.getErrorCount();
                    if (newErrorCount == 0) {
                        System.out.println(String.valueOf(filename) + ": No errors found.");
                    } else if (newErrorCount == 1) {
                        System.err.println(String.valueOf(filename) + ": 1 error found");
                    } else {
                        System.err.println(String.valueOf(filename) + ": " + newErrorCount + " errors found");
                    }
                }
            }
            ++i;
        }
    }
}

