////////////////////////////////////////////////////////////////////////////////
// GLTest.cpp
//
// Andrew Willmott
////////////////////////////////////////////////////////////////////////////////

#include "move.h"

#define NDEBUG
#include <OpenGLES/gl.h>
#include <OpenGLES/egl.h>
#include <CoreGraphics/CGDirectDisplay.h>

#include <stdio.h>
#include <unistd.h>

bool InitializeEGL()
{
    EGLDisplay eglDisplay = eglGetDisplay(0);
    
    EGLint versMajor;
    EGLint versMinor;
    EGLBoolean result = eglInitialize(eglDisplay, &versMajor, &versMinor);
    
    if (result)
    {
        printf("GL version %d.%d\n", versMajor, versMinor);
        
        EGLint numConfigs;
        
        if (eglGetConfigs(eglDisplay, 0, 0, &numConfigs))
        {
            printf("%d egl configs\n", numConfigs);
            
            EGLConfig configs[32];
            eglGetConfigs(eglDisplay, configs, 32, &numConfigs);
            
            int i;
            for (i = 0; i < numConfigs; i++)
            {
                EGLint redBits;
                EGLint greenBits;
                EGLint blueBits;
                EGLint alphaBits;
                
                EGLint bufferSize;
                EGLint depthSize;
                EGLint stencilSize;
                
                EGLint caveat;
                EGLint native;
                
                EGLint level;
                EGLint surfaceType;
                EGLint visualType;
                EGLint visualID;
                
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_RED_SIZE,    &redBits);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_GREEN_SIZE,  &greenBits);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_BLUE_SIZE,   &blueBits);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_ALPHA_SIZE,  &alphaBits);
                
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_BUFFER_SIZE, &bufferSize);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_DEPTH_SIZE,  &depthSize);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_STENCIL_SIZE, &stencilSize);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_CONFIG_CAVEAT, &caveat);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_NATIVE_RENDERABLE, &native);
                
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_LEVEL, &level);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_SURFACE_TYPE, &surfaceType);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_NATIVE_VISUAL_TYPE, &visualType);
                eglGetConfigAttrib(eglDisplay, configs[i], EGL_NATIVE_VISUAL_ID, &visualID);
                
                printf
                (
                     "config %d: rgba=%d:%d:%d:%d(%d), ds=%d:%d, "
                     "caveat=%04x, native=%d, level=%d, surface=%04x, visual=%04x, id=%d\n",
                     i + 1, 
                     redBits, greenBits, blueBits, alphaBits, bufferSize, depthSize, stencilSize,
                     caveat, native, level, surfaceType, visualType, visualID
                 );
            }
            
            EGLint configAttribs[] =
            {
                EGL_BUFFER_SIZE, 16,
                EGL_DEPTH_SIZE, 16,
                EGL_SURFACE_TYPE, EGL_WINDOW_BIT, // EGL_WINDOW_BIT, EGL_PIXMAP_BIT,
                EGL_NONE
            };
            
            EGLConfig eglConfig = 0;
            if (!eglChooseConfig(eglDisplay, configAttribs, &eglConfig, 1, &numConfigs) || (numConfigs != 1))
            {
                printf("failed to find usable config =(\n");
            }
            else
            {
                GLint configID;
                eglGetConfigAttrib(eglDisplay, eglConfig, EGL_CONFIG_ID, &configID);
                printf("chose config %d\n", configID);
            }
            
            EGLContext eglContext = eglCreateContext(eglDisplay, eglConfig, EGL_NO_CONTEXT, 0);
            
            if (eglContext == EGL_NO_CONTEXT)
                printf("failed to allocate context =(\n");
            
            EGLSurface eglSurface = eglCreateWindowSurface(eglDisplay, eglConfig, 0, 0);
            if (eglSurface == EGL_NO_SURFACE)
                printf("failed to create surface =(\n");
            
            return eglMakeCurrent(eglDisplay, eglSurface, eglSurface, eglContext);
        }
        else
            printf("GL get configs failed\n");
    }
    else
        printf("GL init failed\n");
    
    return false;
}

void ShutdownEGL()
{
    eglMakeCurrent(eglGetCurrentDisplay(), EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
    eglTerminate(eglGetCurrentDisplay());
}

void DrawTriangle()
{
	// Vertex data
	GLfloat vertices[] = 
    {  -0.4f,	-0.4f,	0.0f,
        0.4f,	-0.4f,	0.0f,
        0.0f,	 0.4f,	0.0f };
	
	// Enable vertex arrays
	glEnableClientState(GL_VERTEX_ARRAY);
	
	// Points the the vertex data
	glVertexPointer(3, GL_FLOAT, 0, vertices);
    
	// Set color data in the same way
	GLfloat colors[] = 
    {	
        1,0,0,1, //Red
        0,1,0,1, //Green
        0,0,1,1  //Blue
    };
    
	glEnableClientState(GL_COLOR_ARRAY);
	glColorPointer(4, GL_FLOAT, 0, colors);
    
	glDrawArrays(GL_TRIANGLES, 0, 3);
}




void DrawElements()
{
    // Enable vertex arrays
    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_COLOR_ARRAY);
    
	for (int i = 0; i < elistElts; i++) 
    {
        elem_t* el = elist + i;
        
        float verts[] =
        {
            el->pos[0] + el->vervec[0],
            el->pos[1] + el->vervec[1],
            el->pos[2],
            el->col[0], el->col[1], el->col[2], 1.0f,
            
            el->pos[0] + el->vervec[1],
            el->pos[1] - el->vervec[0],
            el->pos[2],
            el->col[0], el->col[1], el->col[2], 1.0f,
            
            el->pos[0] - el->vervec[0],
            el->pos[1] - el->vervec[1],
            el->pos[2],
            el->col[0], el->col[1], el->col[2], 1.0f
        };
        
        // Points the the vertex data
        glVertexPointer(3, GL_FLOAT, 28, verts + 0);
        glColorPointer (4, GL_FLOAT, 28, verts + 3);
        
        glDrawArrays(GL_TRIANGLES, 0, 3);
    }
}

int main(int argc, const char *argv[])
{
    printf("hello world\n");
    
    if (InitializeEGL())
    {    
        //        CGDirectDisplayID mainDisplay = CGMainDisplayID();
        //        CGDisplayCapture(mainDisplay);
        
        init_move(100);
        
        while (1)
        {
            // DrawTriangle();
            
            glClearColor(0, 0, 0, 0);            
    
            glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
            
            DrawElements();
            
            if (!eglSwapBuffers(eglGetCurrentDisplay(), eglGetCurrentSurface(EGL_DRAW)))
                printf("swap error: %04x\n", eglGetError());
            
            move_increment();
            //  usleep(33);
        }
        
        ShutdownEGL();
        // CGDisplayRelease(mainDisplay);
    }
    
    return 0;
}
