clear all
%close all
figure;

    
% Generate data
n = 1000; 
%B=ones(n,1); 
%B=zeros(n,1); 
B = double(randn(n,1)>0);
X = B.*(-2+2*randn(n,1))+(1-B).*(4+0.5*randn(n,1));
xmax = 5;
X = X(find(abs(X)<=xmax));
n = length(X);
x = linspace(-xmax,xmax,200);

%Bandwidth
h = 2 % 1, 0.5, 2


% Histogram
m = 2*xmax/h;
bin_centers = [];
for i = -xmax+h/2:h:xmax
    bin_centers = [bin_centers i];
end
H = hist(X,bin_centers);
H = kron(H,ones(1,200/m))./(n*h);

% Kernel Density Estimation using Boxcar kernel
K = @(a) (abs(a)<0.5); % Boxcar
y = arrayfun(kde(X,h,K),x);
ymax = max(max(H),max(y))+0.02;

% plot Data points
plot(X, zeros(n,1),'rO');
axis([-5 5 0 ymax])
%pause
hold on
% plot Histogram estimate
plot(x,H,'m.-');
axis([-5 5 0 ymax])
%pause
hold on
% plot Kernel density estimate (Boxcar)
plot(x,y,'b.-');
axis([-5 5 0 ymax])
%pause
hold on

% Kernel Density Estimation using Gaussian kernel
K = @(a) (exp(-a^2/2)/sqrt(2*pi)); % Norm kern
y = arrayfun(kde(X,h,K),x);

% plot Kernel density estimate (Gaussian)
plot(x,y,'k.-');
axis([-5 5 0 ymax])
