/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.recorders;

import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Replace;
import edu.cmu.scs.fluorite.plugin.Activator;
import edu.cmu.scs.fluorite.recorders.BaseRecorder;
import edu.cmu.scs.fluorite.recorders.IDocumentRecorderInterceptor;
import edu.cmu.scs.fluorite.util.Utilities;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorPart;

public class DocumentRecorder
extends BaseRecorder
implements IDocumentListener {
    private static DocumentRecorder instance = null;
    private InterceptInfo interceptInfo;

    public static DocumentRecorder getInstance() {
        if (instance == null) {
            instance = new DocumentRecorder();
        }
        return instance;
    }

    private DocumentRecorder() {
    }

    @Override
    public void addListeners(IEditorPart editor) {
        IDocument document = Utilities.getIDocumentForEditor(editor);
        if (document != null) {
            document.addDocumentListener((IDocumentListener)this);
        }
    }

    @Override
    public void removeListeners(IEditorPart editor) {
        try {
            IDocument document = Utilities.getIDocumentForEditor(editor);
            if (document != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIntercept(IDocument doc, long beforeStamp, long afterStamp, IDocumentRecorderInterceptor interceptor) {
        if (this.interceptInfo != null) {
            throw new IllegalStateException();
        }
        this.interceptInfo = new InterceptInfo(doc, beforeStamp, afterStamp, interceptor);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.interceptInfo != null) {
            if (this.interceptInfo.matchesBefore(event.getDocument(), event.getModificationStamp())) {
                this.interceptInfo.setBeforeMatched();
                return;
            }
            this.interceptInfo = null;
        }
        if (event.getLength() > 0) {
            IDocument doc = event.getDocument();
            try {
                int startLine = doc.getLineOfOffset(event.getOffset());
                int endLine = doc.getLineOfOffset(event.getOffset() + event.getLength());
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                String deletedText = null;
                boolean logDeleted = store.getBoolean("EventLogger_LogDeletedText");
                if (logDeleted) {
                    deletedText = doc.get(event.getOffset(), event.getLength());
                }
                String insertedText = null;
                boolean logInserted = store.getBoolean("EventLogger_LogInsertedText");
                if (logInserted) {
                    insertedText = event.getText();
                }
                boolean logSeparateLines = store.getBoolean("EventLogger_LogSeparateLines");
                DocChange command = null;
                if (event.getText().length() > 0) {
                    if (logDeleted && deletedText != null && deletedText.length() > 0 && logInserted && insertedText != null && insertedText.length() > 0) {
                        int idx = 0;
                        while (idx < deletedText.length() && idx < insertedText.length()) {
                            if (deletedText.charAt(idx) != insertedText.charAt(idx)) break;
                            ++idx;
                        }
                        deletedText = deletedText.substring(idx);
                        insertedText = insertedText.substring(idx);
                        if (deletedText.length() == 0) {
                            this.splitAndAdd(logSeparateLines, insertedText, event.getOffset() + idx, doc);
                        } else if (logSeparateLines && insertedText.contains("\r") || insertedText.contains("\n")) {
                            this.getRecorder().recordCommand(new Delete(event.getOffset() + idx, deletedText.length(), startLine, endLine, deletedText, doc));
                            this.splitAndAdd(logSeparateLines, insertedText, event.getOffset() + idx, doc);
                        } else {
                            command = new Replace(event.getOffset() + idx, deletedText.length(), startLine, endLine, insertedText.length(), deletedText, insertedText, doc);
                        }
                    } else {
                        command = new Replace(event.getOffset(), event.getLength(), startLine, endLine, event.getText().length(), deletedText, insertedText, doc);
                    }
                } else {
                    command = new Delete(event.getOffset(), event.getLength(), startLine, endLine, deletedText, doc);
                }
                if (command != null) {
                    this.getRecorder().recordCommand(command);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (!this.getRecorder().isCurrentlyExecutingCommand()) {
            this.getRecorder().endIncrementalFindMode();
        }
        if (this.interceptInfo != null) {
            if (this.interceptInfo.matchesAfter(event.getDocument(), event.getModificationStamp())) {
                this.interceptInfo.getListener().documentChanged(event, this.getRecorder());
                this.interceptInfo = null;
                return;
            }
            this.interceptInfo = null;
        }
        if (event.getText().length() > 0 && event.getLength() <= 0) {
            try {
                IDocument doc = event.getDocument();
                String text = null;
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (store.getBoolean("EventLogger_LogInsertedText")) {
                    text = event.getText();
                    boolean logSeparateLines = store.getBoolean("EventLogger_LogSeparateLines");
                    this.splitAndAdd(logSeparateLines, text, event.getOffset(), doc);
                } else {
                    Insert command = new Insert(event.getOffset(), text, doc);
                    this.getRecorder().recordCommand(command);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void splitAndAdd(boolean logSeparateLines, String insertedText, int offset, IDocument doc) {
        if (insertedText == null || insertedText.length() == 0) {
            return;
        }
        if (!logSeparateLines || !insertedText.contains("\r") && !insertedText.contains("\n")) {
            this.getRecorder().recordCommand(new Insert(offset, insertedText, doc));
            return;
        }
        int index = -1;
        if (insertedText.startsWith("\r") || insertedText.startsWith("\n")) {
            index = insertedText.startsWith("\r\n") ? 2 : 1;
            while (index < insertedText.length()) {
                char ch = insertedText.charAt(index);
                if (Character.isWhitespace(ch) && ch != '\r' && ch != '\n') {
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            int crIndex = insertedText.indexOf(13);
            int lfIndex = insertedText.indexOf(10);
            if (crIndex > -1) {
                index = crIndex;
            }
            if (lfIndex > -1 && (index == -1 || lfIndex < crIndex)) {
                index = lfIndex;
            }
        }
        this.getRecorder().recordCommand(new Insert(offset, insertedText.substring(0, index), doc));
        this.splitAndAdd(logSeparateLines, insertedText.substring(index), offset + index, doc);
    }

    private static class InterceptInfo {
        private IDocument doc;
        private long beforeStamp;
        private long afterStamp;
        private IDocumentRecorderInterceptor interceptor;
        private boolean beforeMatched;

        public InterceptInfo(IDocument doc, long beforeStamp, long afterStamp, IDocumentRecorderInterceptor interceptor) {
            this.doc = doc;
            this.beforeStamp = beforeStamp;
            this.afterStamp = afterStamp;
            this.interceptor = interceptor;
            this.beforeMatched = false;
        }

        public boolean matchesBefore(IDocument doc, long beforeStamp) {
            return this.doc == doc && this.beforeStamp == beforeStamp;
        }

        public void setBeforeMatched() {
            this.beforeMatched = true;
        }

        public boolean matchesAfter(IDocument doc, long afterStamp) {
            return this.beforeMatched && this.doc == doc && this.afterStamp == afterStamp;
        }

        public IDocumentRecorderInterceptor getListener() {
            return this.interceptor;
        }
    }
}

