/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.recorders;

import edu.cmu.scs.fluorite.commands.FileOpenCommand;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.recorders.BaseRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class PartRecorder
extends BaseRecorder
implements IPartListener2 {
    private static PartRecorder instance = null;

    public static PartRecorder getInstance() {
        if (instance == null) {
            instance = new PartRecorder();
        }
        return instance;
    }

    private PartRecorder() {
    }

    @Override
    public void addListeners(IEditorPart editor) {
    }

    @Override
    public void removeListeners(IEditorPart editor) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            if (this.getRecorder().getEditor() == part) {
                return;
            }
            if (this.getRecorder().getEditor() != null) {
                String filePath = Utilities.getFilePathFromEditor(this.getRecorder().getEditor());
                IDocument currentDoc = Utilities.getDocument(this.getRecorder().getEditor());
                if (filePath != null && currentDoc != null) {
                    EventRecorder.getInstance().getFileSnapshotManager().updateSnapshot(filePath, currentDoc.get());
                }
                this.getRecorder().removeListeners();
            }
            IEditorPart editor = (IEditorPart)part;
            this.getRecorder().addListeners(editor);
            FileOpenCommand newFoc = new FileOpenCommand(editor);
            this.getRecorder().recordCommand(newFoc);
            this.getRecorder().fireActiveFileChangedEvent(newFoc);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            this.getRecorder().removeListeners();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }
}

